/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.jdbc.AbstractIoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBTracingInfo;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;

public class IoTDBNonAlignJDBCResultSet
extends AbstractIoTDBJDBCResultSet {
    private static final int TIMESTAMP_STR_LENGTH = 4;
    private static final String EMPTY_STR = "";
    private String operationType = "";
    private TSQueryNonAlignDataSet tsQueryNonAlignDataSet;
    private byte[][] times;
    private List<String> sgColumns = null;

    IoTDBNonAlignJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, IClientRPCService.Iface client, String sql, long queryId, long sessionId, TSQueryNonAlignDataSet dataset, TSTracingInfo tracingInfo, long timeout, String operationType, List<String> sgColumns, BitSet aliasColumnMap) throws SQLException {
        super(statement, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, client, sql, queryId, sessionId, timeout, sgColumns, aliasColumnMap);
        this.times = new byte[columnNameList.size()][8];
        this.operationType = operationType;
        this.ioTDBRpcDataSet.columnNameList = new ArrayList();
        this.ioTDBRpcDataSet.columnTypeList = new ArrayList();
        this.ioTDBRpcDataSet.columnOrdinalMap = new HashMap();
        this.ioTDBRpcDataSet.columnOrdinalMap.put("Time", 1);
        this.ioTDBRpcDataSet.columnTypeDeduplicatedList = new ArrayList();
        this.ioTDBRpcDataSet.columnTypeDeduplicatedList = new ArrayList(columnNameIndex.size());
        for (int i = 0; i < columnNameIndex.size(); ++i) {
            this.ioTDBRpcDataSet.columnTypeDeduplicatedList.add(null);
        }
        ArrayList<String> newSgColumns = new ArrayList<String>();
        for (int i = 0; i < columnNameList.size(); ++i) {
            String name = EMPTY_STR;
            if (sgColumns != null && sgColumns.size() > 0) {
                name = sgColumns.get(i) + "." + columnNameList.get(i);
                newSgColumns.add(sgColumns.get(i));
                newSgColumns.add(sgColumns.get(i));
            } else {
                name = columnNameList.get(i);
                newSgColumns.add(EMPTY_STR);
                newSgColumns.add(EMPTY_STR);
            }
            this.ioTDBRpcDataSet.columnNameList.add("Time" + name);
            this.ioTDBRpcDataSet.columnNameList.add(name);
            this.ioTDBRpcDataSet.columnTypeList.add(String.valueOf(TSDataType.INT64));
            this.ioTDBRpcDataSet.columnTypeList.add(columnTypeList.get(i));
            if (this.ioTDBRpcDataSet.columnOrdinalMap.containsKey(name)) continue;
            int index = columnNameIndex.get(name);
            this.ioTDBRpcDataSet.columnOrdinalMap.put(name, index + 2);
            this.ioTDBRpcDataSet.columnTypeDeduplicatedList.set(index, TSDataType.valueOf((String)columnTypeList.get(i)));
        }
        this.sgColumns = newSgColumns;
        this.tsQueryNonAlignDataSet = dataset;
        if (tracingInfo != null) {
            this.ioTDBRpcTracingInfo = new IoTDBTracingInfo();
            this.ioTDBRpcTracingInfo.setTsTracingInfo(tracingInfo);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.startsWith("Time")) {
            String column = columnName.substring(4);
            int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(column) - 2;
            if (this.times[index] != null) {
                this.ioTDBRpcDataSet.lastReadWasNull = false;
                return BytesUtils.bytesToLong((byte[])this.times[index]);
            }
            this.ioTDBRpcDataSet.lastReadWasNull = true;
            return 0L;
        }
        int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(columnName) - 2;
        if (this.ioTDBRpcDataSet.values[index] != null) {
            this.ioTDBRpcDataSet.lastReadWasNull = false;
            return BytesUtils.bytesToLong((byte[])this.ioTDBRpcDataSet.values[index]);
        }
        this.ioTDBRpcDataSet.lastReadWasNull = true;
        return 0L;
    }

    @Override
    protected boolean fetchResults() throws SQLException {
        TSFetchResultsReq req = new TSFetchResultsReq(this.ioTDBRpcDataSet.sessionId, this.ioTDBRpcDataSet.sql, this.ioTDBRpcDataSet.fetchSize, this.ioTDBRpcDataSet.queryId, false);
        req.setTimeout(this.ioTDBRpcDataSet.timeout);
        try {
            TSFetchResultsResp resp = this.ioTDBRpcDataSet.client.fetchResults(req);
            try {
                RpcUtils.verifySuccess((TSStatus)resp.getStatus());
            }
            catch (StatementExecutionException e) {
                throw new IoTDBSQLException(e.getMessage(), resp.getStatus());
            }
            if (!resp.hasResultSet) {
                this.ioTDBRpcDataSet.emptyResultSet = true;
                this.close();
            } else {
                this.tsQueryNonAlignDataSet = resp.getNonAlignQueryDataSet();
                if (this.tsQueryNonAlignDataSet == null) {
                    this.ioTDBRpcDataSet.emptyResultSet = true;
                    this.close();
                    return false;
                }
            }
            return resp.hasResultSet;
        }
        catch (TException e) {
            throw new SQLException("Cannot fetch result from server, because of network connection: {} ", e);
        }
    }

    @Override
    protected boolean hasCachedResults() {
        return this.tsQueryNonAlignDataSet != null && this.hasTimesRemaining();
    }

    private boolean hasTimesRemaining() {
        for (ByteBuffer time : this.tsQueryNonAlignDataSet.timeList) {
            if (!time.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void constructOneRow() {
        this.ioTDBRpcDataSet.lastReadWasNull = false;
        for (int i = 0; i < this.tsQueryNonAlignDataSet.timeList.size(); ++i) {
            this.times[i] = null;
            this.ioTDBRpcDataSet.values[i] = null;
            if (((ByteBuffer)this.tsQueryNonAlignDataSet.timeList.get(i)).remaining() >= 8) {
                this.times[i] = new byte[8];
                ((ByteBuffer)this.tsQueryNonAlignDataSet.timeList.get(i)).get(this.times[i]);
                ByteBuffer valueBuffer = (ByteBuffer)this.tsQueryNonAlignDataSet.valueList.get(i);
                TSDataType dataType = (TSDataType)this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(i);
                switch (dataType) {
                    case BOOLEAN: {
                        this.ioTDBRpcDataSet.values[i] = new byte[1];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case INT32: {
                        this.ioTDBRpcDataSet.values[i] = new byte[4];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case INT64: {
                        this.ioTDBRpcDataSet.values[i] = new byte[8];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case FLOAT: {
                        this.ioTDBRpcDataSet.values[i] = new byte[4];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case DOUBLE: {
                        this.ioTDBRpcDataSet.values[i] = new byte[8];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case TEXT: {
                        int length = valueBuffer.getInt();
                        this.ioTDBRpcDataSet.values[i] = ReadWriteIOUtils.readBytes((ByteBuffer)valueBuffer, (int)length);
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(i)));
                    }
                }
                continue;
            }
            this.ioTDBRpcDataSet.values[i] = EMPTY_STR.getBytes();
        }
    }

    @Override
    protected void checkRecord() throws SQLException {
        if (Objects.isNull(this.tsQueryNonAlignDataSet)) {
            throw new SQLException("No record remains");
        }
    }

    @Override
    protected String getValueByName(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.startsWith("Time")) {
            String column = columnName.substring(4);
            int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(column) - 2;
            if (this.times[index] == null || this.times[index].length == 0) {
                return null;
            }
            return String.valueOf(BytesUtils.bytesToLong((byte[])this.times[index]));
        }
        int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.ioTDBRpcDataSet.values.length || this.ioTDBRpcDataSet.values[index] == null || this.ioTDBRpcDataSet.values[index].length < 1) {
            return null;
        }
        return this.ioTDBRpcDataSet.getString(index, (TSDataType)this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(index), this.ioTDBRpcDataSet.values);
    }

    @Override
    protected Object getObjectByName(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.startsWith("Time")) {
            String column = columnName.substring(4);
            int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(column) - 2;
            if (this.times[index] == null || this.times[index].length == 0) {
                return null;
            }
            return BytesUtils.bytesToLong((byte[])this.times[index]);
        }
        int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.ioTDBRpcDataSet.values.length || this.ioTDBRpcDataSet.values[index] == null || this.ioTDBRpcDataSet.values[index].length < 1) {
            return null;
        }
        return this.ioTDBRpcDataSet.getObject(index, (TSDataType)this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(index), this.ioTDBRpcDataSet.values);
    }

    public String getOperationType() {
        return this.operationType;
    }

    public List<String> getSgColumns() {
        return this.sgColumns;
    }
}

