/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.service;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;

@NotThreadSafe
public class PipePluginClassLoaderManager
implements IService {
    private final String libRoot;
    private volatile PipePluginClassLoader activeClassLoader;
    private static PipePluginClassLoaderManager INSTANCE = null;

    private PipePluginClassLoaderManager(String libRoot) throws IOException {
        this.libRoot = libRoot;
        this.activeClassLoader = new PipePluginClassLoader(libRoot);
    }

    public PipePluginClassLoader updateAndGetActiveClassLoader() throws IOException {
        PipePluginClassLoader deprecatedClassLoader = this.activeClassLoader;
        this.activeClassLoader = new PipePluginClassLoader(this.libRoot);
        if (deprecatedClassLoader != null) {
            deprecatedClassLoader.markAsDeprecated();
        }
        return this.activeClassLoader;
    }

    public PipePluginClassLoader getActiveClassLoader() {
        return this.activeClassLoader;
    }

    @Override
    public void start() throws StartupException {
        try {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.libRoot);
            this.activeClassLoader = new PipePluginClassLoader(this.libRoot);
        }
        catch (IOException e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.PIPE_PLUGIN_CLASSLOADER_MANAGER_SERVICE;
    }

    public static synchronized PipePluginClassLoaderManager setupAndGetInstance(String libRoot) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new PipePluginClassLoaderManager(libRoot);
        }
        return INSTANCE;
    }

    public static PipePluginClassLoaderManager getInstance() {
        return INSTANCE;
    }
}

