/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfig {
    private final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfig.class);

    public String getPipeHardlinkTsFileDirName() {
        return this.COMMON_CONFIG.getPipeHardlinkTsFileDirName();
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return this.COMMON_CONFIG.getPipeSubtaskExecutorMaxThreadNum();
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return this.COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount();
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return this.COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration();
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return this.COMMON_CONFIG.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    public int getPipeExtractorAssignerDisruptorRingBufferSize() {
        return this.COMMON_CONFIG.getPipeExtractorAssignerDisruptorRingBufferSize();
    }

    public int getPipeExtractorMatcherCacheSize() {
        return this.COMMON_CONFIG.getPipeExtractorMatcherCacheSize();
    }

    public int getPipeExtractorPendingQueueCapacity() {
        return this.COMMON_CONFIG.getPipeExtractorPendingQueueCapacity();
    }

    public int getPipeExtractorPendingQueueTabletLimit() {
        return this.COMMON_CONFIG.getPipeExtractorPendingQueueTabletLimit();
    }

    public int getPipeConnectorReadFileBufferSize() {
        return this.COMMON_CONFIG.getPipeConnectorReadFileBufferSize();
    }

    public long getPipeConnectorRetryIntervalMs() {
        return this.COMMON_CONFIG.getPipeConnectorRetryIntervalMs();
    }

    public int getPipeConnectorPendingQueueSize() {
        return this.COMMON_CONFIG.getPipeConnectorPendingQueueSize();
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return this.COMMON_CONFIG.isSeperatedPipeHeartbeatEnabled();
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return this.COMMON_CONFIG.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta();
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return this.COMMON_CONFIG.getPipeMetaSyncerInitialSyncDelayMinutes();
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return this.COMMON_CONFIG.getPipeMetaSyncerSyncIntervalMinutes();
    }

    public void printAllConfigs() {
        LOGGER.info("PipeHardlinkTsFileDirName: {}", (Object)this.getPipeHardlinkTsFileDirName());
        LOGGER.info("PipeSubtaskExecutorMaxThreadNum: {}", (Object)this.getPipeSubtaskExecutorMaxThreadNum());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration());
        LOGGER.info("PipeSubtaskExecutorPendingQueueMaxBlockingTimeMs: {}", (Object)this.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs());
        LOGGER.info("PipeExtractorAssignerDisruptorRingBufferSize: {}", (Object)this.getPipeExtractorAssignerDisruptorRingBufferSize());
        LOGGER.info("PipeExtractorMatcherCacheSize: {}", (Object)this.getPipeExtractorMatcherCacheSize());
        LOGGER.info("PipeExtractorPendingQueueCapacity: {}", (Object)this.getPipeExtractorPendingQueueCapacity());
        LOGGER.info("PipeExtractorPendingQueueTabletLimit: {}", (Object)this.getPipeExtractorPendingQueueTabletLimit());
        LOGGER.info("PipeConnectorReadFileBufferSize: {}", (Object)this.getPipeConnectorReadFileBufferSize());
        LOGGER.info("PipeConnectorRetryIntervalMs: {}", (Object)this.getPipeConnectorRetryIntervalMs());
        LOGGER.info("PipeConnectorPendingQueueSize: {}", (Object)this.getPipeConnectorPendingQueueSize());
        LOGGER.info("SeperatedPipeHeartbeatEnabled: {}", (Object)this.isSeperatedPipeHeartbeatEnabled());
        LOGGER.info("PipeHeartbeatIntervalSecondsForCollectingPipeMeta: {}", (Object)this.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta());
        LOGGER.info("PipeMetaSyncerInitialSyncDelayMinutes: {}", (Object)this.getPipeMetaSyncerInitialSyncDelayMinutes());
        LOGGER.info("PipeMetaSyncerSyncIntervalMinutes: {}", (Object)this.getPipeMetaSyncerSyncIntervalMinutes());
    }

    private PipeConfig() {
    }

    public static PipeConfig getInstance() {
        return PipeConfigHolder.INSTANCE;
    }

    private static class PipeConfigHolder {
        private static final PipeConfig INSTANCE = new PipeConfig();

        private PipeConfigHolder() {
        }
    }
}

