/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.IUserAccessor;
import org.apache.iotdb.commons.auth.user.IUserManager;
import org.apache.iotdb.commons.concurrent.HashLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUserManager
implements IUserManager {
    private static final Logger logger = LoggerFactory.getLogger(BasicUserManager.class);
    private static final String NO_SUCH_USER_ERROR = "No such user %s";
    protected Map<String, User> userMap = new HashMap<String, User>();
    protected IUserAccessor accessor;
    protected HashLock lock;

    protected BasicUserManager(IUserAccessor accessor) throws AuthException {
        this.accessor = accessor;
        this.lock = new HashLock();
        this.reset();
    }

    private void initAdmin() throws AuthException {
        User admin;
        try {
            admin = this.getUser(CommonDescriptor.getInstance().getConfig().getAdminName());
        }
        catch (AuthException e) {
            logger.warn("Cannot load admin, Creating a new one", (Throwable)e);
            admin = null;
        }
        if (admin == null) {
            this.createUser(CommonDescriptor.getInstance().getConfig().getAdminName(), CommonDescriptor.getInstance().getConfig().getAdminPassword());
            this.setUserUseWaterMark(CommonDescriptor.getInstance().getConfig().getAdminName(), false);
        }
        logger.info("Admin initialized");
    }

    @Override
    public User getUser(String username) throws AuthException {
        this.lock.readLock(username);
        User user = this.userMap.get(username);
        try {
            if (user == null && (user = this.accessor.loadUser(username)) != null) {
                this.userMap.put(username, user);
            }
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.readUnlock(username);
        }
        if (user != null) {
            user.setLastActiveTime(System.currentTimeMillis());
        }
        return user;
    }

    @Override
    public boolean createUser(String username, String password) throws AuthException {
        AuthUtils.validateUsername(username);
        AuthUtils.validatePassword(password);
        User user = this.getUser(username);
        if (user != null) {
            return false;
        }
        this.lock.writeLock(username);
        try {
            user = new User(username, AuthUtils.encryptPassword(password));
            File userDirPath = new File(this.accessor.getDirPath());
            if (!userDirPath.exists()) {
                this.reset();
            }
            this.accessor.saveUser(user);
            this.userMap.put(username, user);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    @Override
    public boolean deleteUser(String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            if (this.accessor.deleteUser(username)) {
                this.userMap.remove(username);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivilegeToUser(String username, PartialPath path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (user.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            HashSet<Integer> privilegesCopy = new HashSet<Integer>(user.getPrivileges(path));
            user.addPrivilege(path, privilegeId);
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                user.setPrivileges(path, privilegesCopy);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivilegeFromUser(String username, PartialPath path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (!user.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            user.removePrivilege(path, privilegeId);
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                user.addPrivilege(path, privilegeId);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateUserPassword(String username, String newPassword) throws AuthException {
        try {
            AuthUtils.validatePassword(newPassword);
        }
        catch (AuthException e) {
            logger.debug("An illegal password detected ", (Throwable)e);
            return false;
        }
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            String oldPassword = user.getPassword();
            user.setPassword(AuthUtils.encryptPassword(newPassword));
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                user.setPassword(oldPassword);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantRoleToUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (user.hasRole(roleName)) {
                boolean bl = false;
                return bl;
            }
            user.getRoleList().add(roleName);
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                user.getRoleList().remove(roleName);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeRoleFromUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (!user.hasRole(roleName)) {
                boolean bl = false;
                return bl;
            }
            user.getRoleList().remove(roleName);
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                user.getRoleList().add(roleName);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    @Override
    public void reset() throws AuthException {
        this.accessor.reset();
        this.userMap.clear();
        this.initAdmin();
    }

    @Override
    public List<String> listAllUsers() {
        List<String> rtlist = this.accessor.listAllUsers();
        rtlist.sort(null);
        return rtlist;
    }

    @Override
    public boolean isUserUseWaterMark(String username) throws AuthException {
        User user = this.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
        }
        return user.isUseWaterMark();
    }

    @Override
    public void setUserUseWaterMark(String username, boolean useWaterMark) throws AuthException {
        User user = this.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
        }
        boolean oldFlag = user.isUseWaterMark();
        if (oldFlag == useWaterMark) {
            return;
        }
        user.setUseWaterMark(useWaterMark);
        try {
            this.accessor.saveUser(user);
        }
        catch (IOException e) {
            user.setUseWaterMark(oldFlag);
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllUsers(Map<String, User> users) throws AuthException {
        BasicUserManager basicUserManager = this;
        synchronized (basicUserManager) {
            this.reset();
            this.userMap = users;
            for (Map.Entry<String, User> entry : this.userMap.entrySet()) {
                User user = entry.getValue();
                try {
                    this.accessor.saveUser(user);
                }
                catch (IOException e) {
                    throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
                }
            }
        }
    }
}

