/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter.prometheus;

import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.reporter.prometheus.PrometheusTextWriter;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.HistogramSnapshot;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class PrometheusReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusReporter.class);
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private final AbstractMetricManager metricManager;
    private DisposableServer httpServer;

    public PrometheusReporter(AbstractMetricManager metricManager) {
        this.metricManager = metricManager;
    }

    @Override
    public boolean start() {
        if (this.httpServer != null) {
            LOGGER.warn("PrometheusReporter already start!");
            return false;
        }
        try {
            this.httpServer = ((HttpServer)HttpServer.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000)).channelGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE)).port(METRIC_CONFIG.getPrometheusReporterPort().intValue()).route(routes -> routes.get("/metrics", (request, response) -> response.sendString((Publisher)Mono.just((Object)this.scrape())))).bindNow();
        }
        catch (Exception e) {
            this.httpServer = null;
            LOGGER.warn("PrometheusReporter failed to start, because ", (Throwable)e);
            return false;
        }
        LOGGER.info("PrometheusReporter started, use port {}", (Object)METRIC_CONFIG.getPrometheusReporterPort());
        return true;
    }

    private String scrape() {
        String result;
        StringWriter writer = new StringWriter();
        PrometheusTextWriter prometheusTextWriter = new PrometheusTextWriter(writer);
        try {
            for (Map.Entry<MetricInfo, IMetric> metricEntry : this.metricManager.getAllMetrics().entrySet()) {
                HistogramSnapshot snapshot;
                IMetric gauge;
                MetricInfo metricInfo = metricEntry.getKey();
                IMetric metric = metricEntry.getValue();
                String name = metricInfo.getName().replaceAll("[^a-zA-Z0-9:_\\]\\[]", "_");
                MetricType metricType = metricInfo.getMetaInfo().getType();
                if (metric instanceof Counter) {
                    name = name + "_total";
                    prometheusTextWriter.writeHelp(name);
                    prometheusTextWriter.writeType(name, metricInfo.getMetaInfo().getType());
                    Counter counter = (Counter)metric;
                    prometheusTextWriter.writeSample(name, metricInfo.getTags(), counter.count());
                    continue;
                }
                if (metric instanceof Gauge) {
                    prometheusTextWriter.writeHelp(name);
                    prometheusTextWriter.writeType(name, metricInfo.getMetaInfo().getType());
                    gauge = (Gauge)metric;
                    prometheusTextWriter.writeSample(name, metricInfo.getTags(), gauge.value());
                    continue;
                }
                if (metric instanceof AutoGauge) {
                    prometheusTextWriter.writeHelp(name);
                    prometheusTextWriter.writeType(name, metricInfo.getMetaInfo().getType());
                    gauge = (AutoGauge)metric;
                    prometheusTextWriter.writeSample(name, metricInfo.getTags(), gauge.value());
                    continue;
                }
                if (metric instanceof Histogram) {
                    Histogram histogram = (Histogram)metric;
                    snapshot = histogram.takeSnapshot();
                    this.writeSnapshotAndCount(name, metricInfo.getTags(), metricType, snapshot, histogram.count(), prometheusTextWriter);
                    continue;
                }
                if (metric instanceof Rate) {
                    name = name + "_total";
                    prometheusTextWriter.writeHelp(name);
                    prometheusTextWriter.writeType(name, metricInfo.getMetaInfo().getType());
                    Rate rate = (Rate)metric;
                    prometheusTextWriter.writeSample(name, metricInfo.getTags(), rate.getCount());
                    prometheusTextWriter.writeSample(name, this.addTags(metricInfo.getTags(), "rate", "m1"), rate.getOneMinuteRate());
                    prometheusTextWriter.writeSample(name, this.addTags(metricInfo.getTags(), "rate", "m5"), rate.getFiveMinuteRate());
                    prometheusTextWriter.writeSample(name, this.addTags(metricInfo.getTags(), "rate", "m15"), rate.getFifteenMinuteRate());
                    prometheusTextWriter.writeSample(name, this.addTags(metricInfo.getTags(), "rate", "mean"), rate.getMeanRate());
                    continue;
                }
                if (!(metric instanceof Timer)) continue;
                Timer timer = (Timer)metric;
                snapshot = timer.takeSnapshot();
                name = name + "_seconds";
                this.writeSnapshotAndCount(name, metricInfo.getTags(), metricType, snapshot, timer.getCount(), prometheusTextWriter);
            }
            result = ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private void writeSnapshotAndCount(String name, Map<String, String> tags, MetricType type, HistogramSnapshot snapshot, long count, PrometheusTextWriter prometheusTextWriter) throws IOException {
        prometheusTextWriter.writeHelp(name);
        prometheusTextWriter.writeType(name, type);
        prometheusTextWriter.writeSample(name + "_max", tags, snapshot.getMax());
        prometheusTextWriter.writeSample(name + "_sum", tags, snapshot.getSum());
        prometheusTextWriter.writeSample(name + "_count", tags, count);
        prometheusTextWriter.writeSample(name, this.addTags(tags, "quantile", "0.5"), snapshot.getValue(0.5));
        prometheusTextWriter.writeSample(name, this.addTags(tags, "quantile", "0.99"), snapshot.getValue(0.99));
    }

    private Map<String, String> addTags(Map<String, String> tags, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put(key, value);
        return result;
    }

    @Override
    public boolean stop() {
        if (this.httpServer != null) {
            try {
                this.httpServer.disposeNow(Duration.ofSeconds(10L));
                this.httpServer = null;
            }
            catch (Exception e) {
                LOGGER.error("Prometheus Reporter failed to stop, because ", (Throwable)e);
                return false;
            }
        }
        LOGGER.info("PrometheusReporter stop!");
        return true;
    }

    @Override
    public ReporterType getReporterType() {
        return ReporterType.PROMETHEUS;
    }
}

