/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.net;

import java.util.Set;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.net.INetMetricManager;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class NetMetrics
implements IMetricSet {
    private final INetMetricManager netMetricManager = INetMetricManager.getNetMetricManager();
    private static final String RECEIVED_BYTES = "received_bytes";
    private static final String RECEIVED_PACKETS = "received_packets";
    private static final String TRANSMITTED_BYTES = "transmitted_bytes";
    private static final String TRANSMITTED_PACKETS = "transmitted_packets";
    private static final String CONNECTION_NUM = "connection_num";
    private static final String TYPE = "type";
    private static final String IFACE_NAME = "iface_name";
    private static final String RECEIVE = "receive";
    private static final String TRANSMIT = "transmit";
    private static final String PROCESS_NAME = "process_num";
    private final String processName;

    public NetMetrics(String processName) {
        this.processName = processName;
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        Set<String> ifaceSet = this.netMetricManager.getIfaceSet();
        for (String iface : ifaceSet) {
            metricService.createAutoGauge(RECEIVED_BYTES, MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getReceivedByte().getOrDefault(iface, 0L).doubleValue(), TYPE, RECEIVE, IFACE_NAME, iface);
            metricService.createAutoGauge(TRANSMITTED_BYTES, MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getTransmittedBytes().getOrDefault(iface, 0L).doubleValue(), TYPE, TRANSMIT, IFACE_NAME, iface);
            metricService.createAutoGauge(RECEIVED_PACKETS, MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getReceivedPackets().getOrDefault(iface, 0L).doubleValue(), TYPE, RECEIVE, IFACE_NAME, iface);
            metricService.createAutoGauge(TRANSMITTED_PACKETS, MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getTransmittedPackets().getOrDefault(iface, 0L).doubleValue(), TYPE, TRANSMIT, IFACE_NAME, iface);
        }
        metricService.createAutoGauge(CONNECTION_NUM, MetricLevel.NORMAL, this.netMetricManager, INetMetricManager::getConnectionNum, PROCESS_NAME, this.processName);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        Set<String> ifaceSet = this.netMetricManager.getIfaceSet();
        for (String iface : ifaceSet) {
            metricService.remove(MetricType.AUTO_GAUGE, RECEIVED_BYTES, TYPE, RECEIVE, IFACE_NAME, iface);
            metricService.remove(MetricType.AUTO_GAUGE, TRANSMIT, TYPE, TRANSMIT, IFACE_NAME, iface);
            metricService.remove(MetricType.AUTO_GAUGE, RECEIVED_PACKETS, TYPE, RECEIVE, IFACE_NAME, iface);
            metricService.remove(MetricType.AUTO_GAUGE, TRANSMITTED_PACKETS, TYPE, TRANSMIT, IFACE_NAME, iface);
        }
        metricService.remove(MetricType.AUTO_GAUGE, CONNECTION_NUM, PROCESS_NAME, this.processName);
    }
}

