/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.SessionConfig;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.isession.util.Version;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.NoValidValueException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TCreateTimeseriesUsingSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.session.InsertConsumer;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.template.MeasurementNode;
import org.apache.iotdb.session.template.TemplateQueryType;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.session.util.ThreadUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements ISession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    protected static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final String MSG_UNSUPPORTED_DATA_TYPE = "Unsupported data type:";
    public static final String MSG_DONOT_ENABLE_REDIRECT = "Query do not enable redirect, please confirm the session and server conf.";
    private static final ThreadPoolExecutor OPERATION_EXECUTOR = new ThreadPoolExecutor(SessionConfig.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, SessionConfig.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), ThreadUtils.createThreadFactory("SessionExecutor", true));
    protected List<String> nodeUrls;
    protected String username;
    protected String password;
    protected int fetchSize;
    private static final byte TYPE_NULL = -2;
    private long queryTimeoutInMs = -1L;
    protected boolean enableRPCCompression;
    protected int connectionTimeoutInMs;
    protected ZoneId zoneId;
    protected int thriftDefaultBufferSize;
    protected int thriftMaxFrameSize;
    protected TEndPoint defaultEndPoint;
    protected SessionConnection defaultSessionConnection;
    private boolean isClosed = true;
    protected boolean enableRedirection;
    protected volatile Map<String, TEndPoint> deviceIdToEndpoint;
    protected volatile Map<TEndPoint, SessionConnection> endPointToSessionConnection;
    protected boolean enableQueryRedirection = false;
    protected Version version;

    public Session(String host, int rpcPort) {
        this(host, rpcPort, "root", "root", 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, String rpcPort, String username, String password) {
        this(host, Integer.parseInt(rpcPort), username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, long queryTimeoutInMs) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
        this.queryTimeoutInMs = queryTimeoutInMs;
    }

    public Session(String host, int rpcPort, String username, String password, ZoneId zoneId) {
        this(host, rpcPort, username, password, 5000, zoneId, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, boolean enableRedirection) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, enableRedirection, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, boolean enableRedirection) {
        this(host, rpcPort, username, password, fetchSize, zoneId, 1024, 0x4000000, enableRedirection, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableRedirection, Version version) {
        this.defaultEndPoint = new TEndPoint(host, rpcPort);
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableRedirection = enableRedirection;
        this.version = version;
    }

    public Session(List<String> nodeUrls, String username, String password) {
        this(nodeUrls, username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize) {
        this(nodeUrls, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, ZoneId zoneId) {
        this(nodeUrls, username, password, 5000, zoneId, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableRedirection, Version version) {
        this.nodeUrls = nodeUrls;
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableRedirection = enableRedirection;
        this.version = version;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public synchronized void open() throws IoTDBConnectionException {
        this.open(false, 0);
    }

    public synchronized void open(boolean enableRPCCompression) throws IoTDBConnectionException {
        this.open(enableRPCCompression, 0);
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.defaultSessionConnection = this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId);
        this.defaultSessionConnection.setEnableRedirect(this.enableQueryRedirection);
        this.isClosed = false;
        if (this.enableRedirection || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, TEndPoint>();
            this.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.defaultSessionConnection);
        }
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs, Map<String, TEndPoint> deviceIdToEndpoint) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.defaultSessionConnection = this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId);
        this.defaultSessionConnection.setEnableRedirect(this.enableQueryRedirection);
        this.isClosed = false;
        if (this.enableRedirection || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = deviceIdToEndpoint;
            this.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.defaultSessionConnection);
        }
    }

    public synchronized void close() throws IoTDBConnectionException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.enableRedirection) {
                for (SessionConnection sessionConnection : this.endPointToSessionConnection.values()) {
                    sessionConnection.close();
                }
            } else {
                this.defaultSessionConnection.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public SessionConnection constructSessionConnection(Session session, TEndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (endpoint == null) {
            return new SessionConnection(session, zoneId);
        }
        return new SessionConnection(session, endpoint, zoneId);
    }

    public synchronized String getTimeZone() {
        return this.defaultSessionConnection.getTimeZone();
    }

    public synchronized void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        this.defaultSessionConnection.setTimeZone(zoneId);
        this.zoneId = ZoneId.of(zoneId);
    }

    public void setTimeZoneOfSession(String zoneId) {
        this.defaultSessionConnection.setTimeZoneOfSession(zoneId);
        this.zoneId = ZoneId.of(zoneId);
    }

    public void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.setStorageGroup(storageGroup);
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteStorageGroups(Collections.singletonList(storageGroup));
    }

    public void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteStorageGroups(storageGroups);
    }

    public void createDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.setStorageGroup(database);
    }

    public void deleteDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteStorageGroups(Collections.singletonList(database));
    }

    public void deleteDatabases(List<String> databases) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteStorageGroups(databases);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, null, null, null, null);
        this.defaultSessionConnection.createTimeseries(request);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
        this.defaultSessionConnection.createTimeseries(request);
    }

    private TSCreateTimeseriesReq genTSCreateTimeseriesReq(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) {
        TSCreateTimeseriesReq request = new TSCreateTimeseriesReq();
        request.setPath(path);
        request.setDataType(dataType.ordinal());
        request.setEncoding(encoding.ordinal());
        request.setCompressor((int)compressor.serialize());
        request.setProps(props);
        request.setTags(tags);
        request.setAttributes(attributes);
        request.setMeasurementAlias(measurementAlias);
        return request;
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateAlignedTimeseriesReq request = this.getTSCreateAlignedTimeseriesReq(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, null, null);
        this.defaultSessionConnection.createAlignedTimeseries(request);
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateAlignedTimeseriesReq request = this.getTSCreateAlignedTimeseriesReq(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, tagsList, attributesList);
        this.defaultSessionConnection.createAlignedTimeseries(request);
    }

    private TSCreateAlignedTimeseriesReq getTSCreateAlignedTimeseriesReq(String prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        TSCreateAlignedTimeseriesReq request = new TSCreateAlignedTimeseriesReq();
        request.setPrefixPath(prefixPath);
        request.setMeasurements(measurements);
        request.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        request.setMeasurementAlias(measurementAliasList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        return request;
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateMultiTimeseriesReq request = this.genTSCreateMultiTimeseriesReq(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
        this.defaultSessionConnection.createMultiTimeseries(request);
    }

    private TSCreateMultiTimeseriesReq genTSCreateMultiTimeseriesReq(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        request.setPaths(paths);
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        request.setDataTypes(dataTypeOrdinals);
        ArrayList<Integer> encodingOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSEncoding encoding : encodings) {
            encodingOrdinals.add(encoding.ordinal());
        }
        request.setEncodings(encodingOrdinals);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(paths.size());
        for (CompressionType compression : compressors) {
            arrayList.add(Integer.valueOf(compression.serialize()));
        }
        request.setCompressors(arrayList);
        request.setPropsList(propsList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        request.setMeasurementAliasList(measurementAliasList);
        return request;
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        return this.defaultSessionConnection.checkTimeseriesExists(path, this.queryTimeoutInMs);
    }

    public void setQueryTimeout(long timeoutInMs) {
        this.queryTimeoutInMs = timeoutInMs;
    }

    public long getQueryTimeout() {
        return this.queryTimeoutInMs;
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, this.queryTimeoutInMs);
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, timeoutInMs);
    }

    private SessionDataSet executeStatementMayRedirect(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeQueryStatement(sql, timeoutInMs);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeQueryStatement(sql, this.queryTimeoutInMs);
                }
                catch (RedirectException redirectException) {
                    logger.error("{} redirect twice", (Object)sql, (Object)redirectException);
                    throw new StatementExecutionException(sql + " redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.executeNonQueryStatement(sql);
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime, timeOut);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime, timeOut);
                }
                catch (RedirectException redirectException) {
                    logger.error("Redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("Redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeRawDataQuery(paths, startTime, endTime, this.queryTimeoutInMs);
    }

    public SessionDataSet executeLastDataQuery(List<String> paths, long lastTime) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeLastDataQuery(paths, lastTime, this.queryTimeoutInMs);
    }

    public SessionDataSet executeLastDataQuery(List<String> paths, long lastTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeLastDataQuery(paths, lastTime, timeOut);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeLastDataQuery(paths, lastTime, timeOut);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeLastDataQuery(List<String> paths) throws StatementExecutionException, IoTDBConnectionException {
        long time = 0L;
        return this.executeLastDataQuery(paths, time, this.queryTimeoutInMs);
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime, interval);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime, interval);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval, long slidingStep) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime, interval, slidingStep);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeAggregationQuery(paths, aggregations, startTime, endTime, interval, slidingStep);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, Arrays.asList(values), false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private void insertRecord(String prefixPath, TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(prefixPath).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(prefixPath, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(prefixPath) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(prefixPath));
                this.deviceIdToEndpoint.remove(prefixPath);
                try {
                    this.defaultSessionConnection.insertRecord(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private void insertRecord(String deviceId, TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(deviceId).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.defaultSessionConnection.insertRecord(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private SessionConnection getSessionConnection(String deviceId) {
        TEndPoint endPoint;
        if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && (endPoint = this.deviceIdToEndpoint.get(deviceId)) != null && this.endPointToSessionConnection.containsKey(endPoint)) {
            return this.endPointToSessionConnection.get(endPoint);
        }
        return this.defaultSessionConnection;
    }

    public String getTimestampPrecision() throws TException {
        return this.defaultSessionConnection.getClient().getProperties().getTimestampPrecision();
    }

    private void removeBrokenSessionConnection(SessionConnection sessionConnection) {
        if (this.enableRedirection) {
            Map.Entry<Object, SessionConnection> entry;
            TEndPoint endPoint = null;
            Iterator<Map.Entry<Object, SessionConnection>> it = this.endPointToSessionConnection.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().equals(sessionConnection)) continue;
                endPoint = entry.getKey();
                it.remove();
                break;
            }
            it = this.deviceIdToEndpoint.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!((TEndPoint)entry.getValue()).equals(endPoint)) continue;
                it.remove();
            }
        }
    }

    private void handleRedirection(String deviceId, TEndPoint endpoint) {
        if (this.enableRedirection) {
            SessionConnection connection;
            if (endpoint.ip.equals("0.0.0.0")) {
                return;
            }
            AtomicReference exceptionReference = new AtomicReference();
            if (!this.deviceIdToEndpoint.containsKey(deviceId) || !this.deviceIdToEndpoint.get(deviceId).equals(endpoint)) {
                this.deviceIdToEndpoint.put(deviceId, endpoint);
            }
            if ((connection = this.endPointToSessionConnection.computeIfAbsent(endpoint, k -> {
                try {
                    return this.constructSessionConnection(this, endpoint, this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            })) == null) {
                this.deviceIdToEndpoint.remove(deviceId);
                logger.warn("Can not redirect to {}, because session can not connect to it.", (Object)endpoint);
            }
        }
    }

    private void handleQueryRedirection(TEndPoint endPoint) throws IoTDBConnectionException {
        if (this.enableQueryRedirection) {
            AtomicReference exceptionReference = new AtomicReference();
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endPoint, k -> {
                try {
                    SessionConnection sessionConnection = this.constructSessionConnection(this, endPoint, this.zoneId);
                    sessionConnection.setEnableRedirect(this.enableQueryRedirection);
                    return sessionConnection;
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)exceptionReference.get());
            }
            this.defaultSessionConnection = connection;
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, true);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private TSInsertRecordReq filterAndGenTSInsertRecordReq(String prefixPath, long time, List<String> measurements, List<TSDataType> types, List<Object> values, boolean isAligned) throws IoTDBConnectionException {
        boolean isAllValuesNull;
        if (this.hasNull(values) && (isAllValuesNull = this.filterNullValueAndMeasurement(prefixPath, measurements = new ArrayList<String>(measurements), types = new ArrayList<TSDataType>(types), values = new ArrayList<Object>(values)))) {
            throw new NoValidValueException("All inserted data is null.");
        }
        return this.genTSInsertRecordReq(prefixPath, time, measurements, types, values, isAligned);
    }

    private TSInsertRecordReq genTSInsertRecordReq(String prefixPath, long time, List<String> measurements, List<TSDataType> types, List<Object> values, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
        request.setValues(buffer);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, true);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private TSInsertStringRecordReq filterAndGenTSInsertStringRecordReq(String prefixPath, long time, List<String> measurements, List<String> values, boolean isAligned) {
        boolean isAllValueNull;
        if (this.hasNull(values) && (isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values = new ArrayList<String>(values), prefixPath, measurements = new ArrayList<String>(measurements)))) {
            throw new NoValidValueException("All inserted data is null.");
        }
        return this.genTSInsertStringRecordReq(prefixPath, time, measurements, values, isAligned);
    }

    private TSInsertStringRecordReq genTSInsertStringRecordReq(String prefixPath, long time, List<String> measurements, List<String> values, boolean isAligned) {
        TSInsertStringRecordReq request = new TSInsertStringRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setValues(values);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, false);
        } else {
            TSInsertStringRecordsReq request;
            try {
                request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
                return;
            }
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void filterNullValueAndMeasurement(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<Object>> valuesList, List<List<TSDataType>> typesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<Object> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            List<TSDataType> types = typesList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurement(deviceIds.get(i), measurements, types, values);
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            deviceIds.remove(i);
            times.remove(i);
            typesList.remove(i);
        }
        if (valuesList.size() == 0) {
            throw new NoValidValueException("All inserted data is null.");
        }
    }

    private void filterNullValueAndMeasurementOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<TSDataType> types;
            List<Object> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurement(deviceId, measurements, types = typesList.get(i), values);
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            typesList.remove(i);
            times.remove(i);
        }
        if (valuesList.size() == 0) {
            throw new NoValidValueException("All inserted data is null.");
        }
    }

    private void filterNullValueAndMeasurementWithStringTypeOfOneDevice(List<Long> times, String deviceId, List<List<String>> measurementsList, List<List<String>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<String> measurements;
            List<String> values = valuesList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurementWithStringType(values, deviceId, measurements = measurementsList.get(i));
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            times.remove(i);
        }
        if (valuesList.size() == 0) {
            throw new NoValidValueException("All inserted data is null.");
        }
    }

    private boolean filterNullValueAndMeasurement(String deviceId, List<String> measurementsList, List<TSDataType> types, List<Object> valuesList) {
        HashMap<String, Object> nullMap = new HashMap<String, Object>();
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (valuesList.get(i) != null) continue;
            nullMap.put(measurementsList.get(i), valuesList.get(i));
            valuesList.remove(i);
            measurementsList.remove(i);
            types.remove(i);
        }
        if (valuesList.size() == 0) {
            logger.info("All values of the {} are null,null values are {}", (Object)deviceId, (Object)((Object)nullMap).toString());
            return true;
        }
        logger.info("Some values of {} are null,null values are {}", (Object)deviceId, (Object)((Object)nullMap).toString());
        return false;
    }

    private void filterNullValueAndMeasurementWithStringType(List<String> prefixPaths, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<String> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            boolean isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values, prefixPaths.get(i), measurements);
            if (!isAllValueNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            times.remove(i);
            prefixPaths.remove(i);
        }
        if (valuesList.size() == 0) {
            throw new NoValidValueException("All inserted data is null.");
        }
    }

    private boolean filterNullValueAndMeasurementWithStringType(List<String> valuesList, String deviceId, List<String> measurementsList) {
        HashMap<String, String> nullMap = new HashMap<String, String>();
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (valuesList.get(i) != null) continue;
            nullMap.put(measurementsList.get(i), valuesList.get(i));
            valuesList.remove(i);
            measurementsList.remove(i);
        }
        if (valuesList.size() == 0) {
            logger.info("All values of the {} are null,null values are {}", (Object)deviceId, (Object)((Object)nullMap).toString());
            return true;
        }
        logger.info("Some values of {} are null,null values are {}", (Object)deviceId, (Object)((Object)nullMap).toString());
        return false;
    }

    private boolean hasNull(List valuesList) {
        boolean haveNull = false;
        for (int i1 = 0; i1 < valuesList.size(); ++i1) {
            Object o = valuesList.get(i1);
            if (o instanceof List) {
                List o1 = (List)o;
                if (!this.hasNull(o1)) continue;
                haveNull = true;
                break;
            }
            if (o != null) continue;
            haveNull = true;
            break;
        }
        return haveNull;
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, true);
        } else {
            TSInsertStringRecordsReq request;
            try {
                request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, true);
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
                return;
            }
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertStringRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertStringRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertStringRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertStringRecordsReq request = recordsGroup.getOrDefault(connection, new TSInsertStringRecordsReq());
            request.setIsAligned(isAligned);
            try {
                this.filterAndUpdateTSInsertStringRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), valuesList.get(i));
                recordsGroup.putIfAbsent(connection, request);
                continue;
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceIds.get(i), times.get(i), measurementsList.get(i).toString()});
            }
        }
        this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
    }

    private TSInsertStringRecordsReq filterAndGenTSInsertStringRecordsReq(List<String> prefixPaths, List<Long> time, List<List<String>> measurements, List<List<String>> values, boolean isAligned) {
        if (this.hasNull(values)) {
            values = this.changeToArrayListWithStringType(values);
            measurements = this.changeToArrayListWithStringType(measurements);
            prefixPaths = new ArrayList<String>(prefixPaths);
            time = new ArrayList<Long>(time);
            this.filterNullValueAndMeasurementWithStringType(prefixPaths, time, measurements, values);
        }
        return this.genTSInsertStringRecordsReq(prefixPaths, time, measurements, values, isAligned);
    }

    private List<List<String>> changeToArrayListWithStringType(List<List<String>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<String>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<String> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<String>(currentValue));
        }
        return values;
    }

    private List<List<Object>> changeToArrayList(List<List<Object>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<Object>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<Object> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<Object>(currentValue));
        }
        return values;
    }

    private List<List<TSDataType>> changeToArrayListWithTSDataType(List<List<TSDataType>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<TSDataType>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<TSDataType> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<TSDataType>(currentValue));
        }
        return values;
    }

    private TSInsertStringRecordsReq genTSInsertStringRecordsReq(List<String> prefixPaths, List<Long> time, List<List<String>> measurements, List<List<String>> values, boolean isAligned) {
        TSInsertStringRecordsReq request = new TSInsertStringRecordsReq();
        request.setPrefixPaths(prefixPaths);
        request.setTimestamps(time);
        request.setMeasurementsList(measurements);
        request.setValuesList(values);
        request.setIsAligned(isAligned);
        return request;
    }

    private void filterAndUpdateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        boolean isAllValueNull;
        if (this.hasNull(values) && (isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values = new ArrayList<String>(values), deviceId, measurements = new ArrayList<String>(measurements)))) {
            throw new NoValidValueException("All inserted data is null.");
        }
        this.updateTSInsertStringRecordsReq(request, deviceId, time, measurements, values);
    }

    private void updateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time);
        request.addToMeasurementsList(measurements);
        request.addToValuesList(values);
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, false);
        } else {
            TSInsertRecordsReq request;
            try {
                request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
                return;
            }
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, true);
        } else {
            TSInsertRecordsReq request;
            try {
                request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, true);
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
                return;
            }
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsOfOneDeviceReq request;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        try {
            request = this.filterAndGenTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],times are [{}],measurements are [{}]", new Object[]{deviceId, times.toString(), measurementsList.toString()});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.defaultSessionConnection.insertRecordsOfOneDevice(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsOfOneDeviceReq req;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        try {
            req = this.filterAndGenTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],times are [{}],measurements are [{}]", new Object[]{deviceId, times.toString(), measurementsList.toString()});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.defaultSessionConnection.insertStringRecordsOfOneDevice(req);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsOfOneDeviceReq request;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, subMeasurementsList and valuesList's size should be equal");
        }
        try {
            request = this.filterAndGenTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, true);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],times are [{}],measurements are [{}]", new Object[]{deviceId, times.toString(), measurementsList.toString()});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.defaultSessionConnection.insertRecordsOfOneDevice(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsOfOneDeviceReq req;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        try {
            req = this.filterAndGenTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, true);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],times are [{}],measurements are [{}]", new Object[]{deviceId, times.toString(), measurementsList.toString()});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.defaultSessionConnection.insertStringRecordsOfOneDevice(req);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    private TSInsertRecordsOfOneDeviceReq filterAndGenTSInsertRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted, boolean isAligned) throws IoTDBConnectionException, BatchExecutionException {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayList(valuesList);
            typesList = this.changeToArrayListWithTSDataType(typesList);
            times = new ArrayList<Long>(times);
            this.filterNullValueAndMeasurementOfOneDevice(prefixPath, times, measurementsList, typesList, valuesList);
        }
        return this.genTSInsertRecordsOfOneDeviceReq(prefixPath, times, measurementsList, typesList, valuesList, haveSorted, isAligned);
    }

    private TSInsertRecordsOfOneDeviceReq genTSInsertRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted, boolean isAligned) throws IoTDBConnectionException, BatchExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < times.size(); ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            typesList = Session.sortList(typesList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertRecordsOfOneDeviceReq request = new TSInsertRecordsOfOneDeviceReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        request.setIsAligned(isAligned);
        return request;
    }

    private TSInsertStringRecordsOfOneDeviceReq filterAndGenTSInsertStringRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted, boolean isAligned) {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayListWithStringType(valuesList);
            times = new ArrayList<Long>(times);
            this.filterNullValueAndMeasurementWithStringTypeOfOneDevice(times, prefixPath, measurementsList, valuesList);
        }
        return this.genTSInsertStringRecordsOfOneDeviceReq(prefixPath, times, measurementsList, valuesList, haveSorted, isAligned);
    }

    private TSInsertStringRecordsOfOneDeviceReq genTSInsertStringRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted, boolean isAligned) {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < index.length; ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertStringRecordsOfOneDeviceReq req = new TSInsertStringRecordsOfOneDeviceReq();
        req.setPrefixPath(prefixPath);
        req.setTimestamps(times);
        req.setMeasurementsList(measurementsList);
        req.setValuesList(valuesList);
        req.setIsAligned(isAligned);
        return req;
    }

    private static <T> List<T> sortList(List<T> source, Integer[] index) {
        return Arrays.stream(index).map(source::get).collect(Collectors.toList());
    }

    private List<ByteBuffer> objectValuesListToByteBufferList(List<List<Object>> valuesList, List<List<TSDataType>> typesList) throws IoTDBConnectionException {
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < valuesList.size(); ++i) {
            ByteBuffer buffer = SessionUtils.getValueBuffer(typesList.get(i), valuesList.get(i));
            buffersList.add(buffer);
        }
        return buffersList;
    }

    private void insertRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertRecordsReq request = recordsGroup.getOrDefault(connection, new TSInsertRecordsReq());
            request.setIsAligned(isAligned);
            try {
                this.filterAndUpdateTSInsertRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), typesList.get(i), valuesList.get(i));
                recordsGroup.putIfAbsent(connection, request);
                continue;
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements are [{}]", new Object[]{deviceIds.get(i), times.get(i), measurementsList.get(i).toString()});
            }
        }
        this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
    }

    private TSInsertRecordsReq filterAndGenTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayList(valuesList);
            deviceIds = new ArrayList<String>(deviceIds);
            times = new ArrayList<Long>(times);
            typesList = this.changeToArrayListWithTSDataType(typesList);
            this.filterNullValueAndMeasurement(deviceIds, times, measurementsList, valuesList, typesList);
        }
        return this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, isAligned);
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setPrefixPaths(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        request.setIsAligned(isAligned);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        return request;
    }

    private void filterAndUpdateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        boolean isAllValuesNull;
        if (this.hasNull(values) && (isAllValuesNull = this.filterNullValueAndMeasurement(deviceId, measurements = new ArrayList<String>(measurements), types = new ArrayList<TSDataType>(types), values = new ArrayList<Object>(values)))) {
            throw new NoValidValueException("All inserted data is null.");
        }
        this.updateTSInsertRecordsReq(request, deviceId, time, measurements, types, values);
    }

    private void updateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time.longValue());
        request.addToMeasurementsList(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
        request.addToValuesList(buffer);
    }

    public void insertTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        try {
            this.getSessionConnection(tablet.deviceId).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(tablet.deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(tablet.deviceId));
                this.deviceIdToEndpoint.remove(tablet.deviceId);
                try {
                    this.defaultSessionConnection.insertTablet(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertAlignedTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertAlignedTablet(tablet, false);
    }

    public void insertAlignedTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, true);
        try {
            this.getSessionConnection(tablet.deviceId).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(tablet.deviceId) != null) {
                logger.warn("Session can not connect to {}", (Object)this.deviceIdToEndpoint.get(tablet.deviceId));
                this.deviceIdToEndpoint.remove(tablet.deviceId);
                try {
                    this.defaultSessionConnection.insertTablet(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private TSInsertTabletReq genTSInsertTabletReq(Tablet tablet, boolean sorted, boolean isAligned) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        TSInsertTabletReq request = new TSInsertTabletReq();
        for (IMeasurementSchema measurementSchema : tablet.getSchemas()) {
            request.addToMeasurements(measurementSchema.getMeasurementId());
            request.addToTypes(measurementSchema.getType().ordinal());
        }
        request.setPrefixPath(tablet.deviceId);
        request.setIsAligned(isAligned);
        request.setTimestamps(SessionUtils.getTimeBuffer(tablet));
        request.setValues(SessionUtils.getValueBuffer(tablet));
        request.setSize(tablet.rowSize);
        return request;
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableRedirection) {
            this.insertTabletsWithLeaderCache(tablets, sorted, false);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
            try {
                this.defaultSessionConnection.insertTablets(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablets(tablets, false);
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableRedirection) {
            this.insertTabletsWithLeaderCache(tablets, sorted, true);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, true);
            try {
                this.defaultSessionConnection.insertTablets(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertTabletsWithLeaderCache(Map<String, Tablet> tablets, boolean sorted, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertTabletsReq> tabletGroup = new HashMap<SessionConnection, TSInsertTabletsReq>();
        for (Map.Entry<String, Tablet> entry : tablets.entrySet()) {
            SessionConnection connection = this.getSessionConnection(entry.getKey());
            TSInsertTabletsReq request = tabletGroup.computeIfAbsent(connection, k -> new TSInsertTabletsReq());
            this.updateTSInsertTabletsReq(request, entry.getValue(), sorted, isAligned);
        }
        this.insertByGroup(tabletGroup, SessionConnection::insertTablets);
    }

    private TSInsertTabletsReq genTSInsertTabletsReq(List<Tablet> tablets, boolean sorted, boolean isAligned) throws BatchExecutionException {
        TSInsertTabletsReq request = new TSInsertTabletsReq();
        if (tablets.isEmpty()) {
            throw new BatchExecutionException("No tablet is inserting!");
        }
        for (Tablet tablet : tablets) {
            this.updateTSInsertTabletsReq(request, tablet, sorted, isAligned);
        }
        return request;
    }

    private void updateTSInsertTabletsReq(TSInsertTabletsReq request, Tablet tablet, boolean sorted, boolean isAligned) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        request.addToPrefixPaths(tablet.deviceId);
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        request.setIsAligned(isAligned);
        for (IMeasurementSchema measurementSchema : tablet.getSchemas()) {
            measurements.add(measurementSchema.getMeasurementId());
            dataTypes.add(measurementSchema.getType().ordinal());
        }
        request.addToMeasurementsList(measurements);
        request.addToTypesList(dataTypes);
        request.addToTimestampsList(SessionUtils.getTimeBuffer(tablet));
        request.addToValuesList(SessionUtils.getValueBuffer(tablet));
        request.addToSizeList(tablet.rowSize);
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablet(tablet, false);
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        this.defaultSessionConnection.testInsertTablet(request);
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablets(tablets, false);
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
        this.defaultSessionConnection.testInsertTablets(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
            return;
        }
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsReq request;
        try {
            request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]", new Object[]{deviceIds.toString(), times.toString(), measurementsList.toString()});
            return;
        }
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]", new Object[]{deviceId, time, measurements.toString()});
            return;
        }
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(Collections.singletonList(path));
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(paths);
    }

    public void deleteData(String path, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(Collections.singletonList(path), Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(paths, Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        TSDeleteDataReq request = this.genTSDeleteDataReq(paths, startTime, endTime);
        this.defaultSessionConnection.deleteData(request);
    }

    private TSDeleteDataReq genTSDeleteDataReq(List<String> paths, long startTime, long endTime) {
        TSDeleteDataReq request = new TSDeleteDataReq();
        request.setPaths(paths);
        request.setStartTime(startTime);
        request.setEndTime(endTime);
        return request;
    }

    private boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.rowSize; ++i) {
            if (tablet.timestamps[i] >= tablet.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }

    private boolean checkSorted(List<Long> times) {
        for (int i = 1; i < times.size(); ++i) {
            if (times.get(i) >= times.get(i - 1)) continue;
            return false;
        }
        return true;
    }

    private void checkSortedThrowable(Tablet tablet) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            throw new BatchExecutionException("Times in Tablet are not in ascending order");
        }
    }

    public void sortTablet(Tablet tablet) {
        Integer[] index = new Integer[tablet.rowSize];
        for (int i = 0; i < tablet.rowSize; ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> tablet.timestamps[o]));
        Arrays.sort(tablet.timestamps, 0, tablet.rowSize);
        int columnIndex = 0;
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)tablet.getSchemas().get(i);
            if (schema instanceof MeasurementSchema) {
                tablet.values[columnIndex] = this.sortList(tablet.values[columnIndex], schema.getType(), index);
                if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null) {
                    tablet.bitMaps[columnIndex] = this.sortBitMap(tablet.bitMaps[columnIndex], index);
                }
                ++columnIndex;
                continue;
            }
            int measurementSize = schema.getSubMeasurementsList().size();
            for (int j = 0; j < measurementSize; ++j) {
                tablet.values[columnIndex] = this.sortList(tablet.values[columnIndex], (TSDataType)schema.getSubMeasurementsTSDataTypeList().get(j), index);
                if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null) {
                    tablet.bitMaps[columnIndex] = this.sortBitMap(tablet.bitMaps[columnIndex], index);
                }
                ++columnIndex;
            }
        }
    }

    private Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(MSG_UNSUPPORTED_DATA_TYPE + dataType);
    }

    private BitMap sortBitMap(BitMap bitMap, Integer[] index) {
        BitMap sortedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < index.length; ++i) {
            if (!bitMap.isMarked(index[i].intValue())) continue;
            sortedBitMap.mark(i);
        }
        return sortedBitMap;
    }

    public void setSchemaTemplate(String templateName, String prefixPath) throws IoTDBConnectionException, StatementExecutionException {
        TSSetSchemaTemplateReq request = this.getTSSetSchemaTemplateReq(templateName, prefixPath);
        this.defaultSessionConnection.setSchemaTemplate(request);
    }

    public void createSchemaTemplate(Template template) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSCreateSchemaTemplateReq req = new TSCreateSchemaTemplateReq();
        req.setName(template.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        template.serialize((OutputStream)baos);
        req.setSerializedTemplate(baos.toByteArray());
        baos.close();
        this.defaultSessionConnection.createSchemaTemplate(req);
    }

    public void createSchemaTemplate(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IOException, IoTDBConnectionException, StatementExecutionException {
        Template temp = new Template(templateName, isAligned);
        int len = measurements.size();
        if (len != dataTypes.size() || len != encodings.size() || len != compressors.size()) {
            throw new StatementExecutionException("Different length of measurements, datatypes, encodings or compressors when create schema tempalte.");
        }
        for (int idx = 0; idx < measurements.size(); ++idx) {
            MeasurementNode mNode = new MeasurementNode(measurements.get(idx), dataTypes.get(idx), encodings.get(idx), compressors.get(idx));
            temp.addToTemplate((TemplateNode)mNode);
        }
        this.createSchemaTemplate(temp);
    }

    @Deprecated
    public void createSchemaTemplate(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> flatMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> flatDataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> flatEncodings = new ArrayList<TSEncoding>();
        for (int idx = 0; idx < measurements.size(); ++idx) {
            flatMeasurements.add(measurements.get(idx).get(0));
            flatDataTypes.add(dataTypes.get(idx).get(0));
            flatEncodings.add(encodings.get(idx).get(0));
        }
        try {
            this.createSchemaTemplate(name, flatMeasurements, flatDataTypes, flatEncodings, compressors, false);
        }
        catch (IOException e) {
            throw new StatementExecutionException(e.getMessage());
        }
    }

    public void addAlignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        req.setIsAligned(true);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addAlignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(Integer.valueOf(compressor.serialize())));
        req.setIsAligned(true);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        req.setIsAligned(false);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(Integer.valueOf(compressor.serialize())));
        req.setIsAligned(false);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void deleteNodeInTemplate(String templateName, String path) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSPruneSchemaTemplateReq req = new TSPruneSchemaTemplateReq();
        req.setName(templateName);
        req.setPath(path);
        this.defaultSessionConnection.pruneSchemaTemplate(req);
    }

    public int countMeasurementsInTemplate(String name) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(name);
        req.setQueryType(TemplateQueryType.COUNT_MEASUREMENTS.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getCount();
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.IS_MEASUREMENT.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.result;
    }

    public boolean isPathExistInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.PATH_EXIST.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.result;
    }

    public List<String> showMeasurementsInTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement("");
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showMeasurementsInTemplate(String templateName, String pattern) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement(pattern);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName("");
        req.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateSetOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateUsingOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public void unsetSchemaTemplate(String prefixPath, String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSUnsetSchemaTemplateReq request = this.getTSUnsetSchemaTemplateReq(prefixPath, templateName);
        this.defaultSessionConnection.unsetSchemaTemplate(request);
    }

    public void dropSchemaTemplate(String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSDropSchemaTemplateReq request = this.getTSDropSchemaTemplateReq(templateName);
        this.defaultSessionConnection.dropSchemaTemplate(request);
    }

    private TSSetSchemaTemplateReq getTSSetSchemaTemplateReq(String templateName, String prefixPath) {
        TSSetSchemaTemplateReq request = new TSSetSchemaTemplateReq();
        request.setTemplateName(templateName);
        request.setPrefixPath(prefixPath);
        return request;
    }

    private TSUnsetSchemaTemplateReq getTSUnsetSchemaTemplateReq(String prefixPath, String templateName) {
        TSUnsetSchemaTemplateReq request = new TSUnsetSchemaTemplateReq();
        request.setPrefixPath(prefixPath);
        request.setTemplateName(templateName);
        return request;
    }

    private TSDropSchemaTemplateReq getTSDropSchemaTemplateReq(String templateName) {
        TSDropSchemaTemplateReq request = new TSDropSchemaTemplateReq();
        request.setTemplateName(templateName);
        return request;
    }

    public void createTimeseriesUsingSchemaTemplate(List<String> devicePathList) throws IoTDBConnectionException, StatementExecutionException {
        if (devicePathList == null || devicePathList.contains(null)) {
            throw new StatementExecutionException("Given device path list should not be  or contains null.");
        }
        TCreateTimeseriesUsingSchemaTemplateReq request = new TCreateTimeseriesUsingSchemaTemplateReq();
        request.setDevicePathList(devicePathList);
        this.defaultSessionConnection.createTimeseriesUsingSchemaTemplate(request);
    }

    private <T> void insertByGroup(Map<SessionConnection, T> recordsGroup, InsertConsumer<T> insertConsumer) throws IoTDBConnectionException, StatementExecutionException {
        List completableFutures = recordsGroup.entrySet().stream().map(entry -> {
            SessionConnection connection = (SessionConnection)entry.getKey();
            Object recordsReq = entry.getValue();
            return CompletableFuture.runAsync(() -> {
                try {
                    insertConsumer.insert(connection, recordsReq);
                }
                catch (RedirectException e) {
                    e.getDeviceEndPointMap().forEach(this::handleRedirection);
                }
                catch (StatementExecutionException e) {
                    throw new CompletionException(e);
                }
                catch (IoTDBConnectionException e) {
                    this.removeBrokenSessionConnection(connection);
                    try {
                        insertConsumer.insert(this.defaultSessionConnection, recordsReq);
                    }
                    catch (IoTDBConnectionException | StatementExecutionException ex) {
                        throw new CompletionException(ex);
                    }
                    catch (RedirectException redirectException) {
                        // empty catch block
                    }
                }
            }, OPERATION_EXECUTOR);
        }).collect(Collectors.toList());
        StringBuilder errMsgBuilder = new StringBuilder();
        for (CompletableFuture completableFuture : completableFutures) {
            try {
                completableFuture.join();
            }
            catch (CompletionException completionException) {
                Throwable cause = completionException.getCause();
                logger.error("Meet error when async insert!", cause);
                if (cause instanceof IoTDBConnectionException) {
                    throw (IoTDBConnectionException)cause;
                }
                errMsgBuilder.append(cause.getMessage());
            }
        }
        if (errMsgBuilder.length() > 0) {
            throw new StatementExecutionException(errMsgBuilder.toString());
        }
    }

    public boolean isEnableQueryRedirection() {
        return this.enableQueryRedirection;
    }

    public void setEnableQueryRedirection(boolean enableQueryRedirection) {
        this.enableQueryRedirection = enableQueryRedirection;
    }

    public boolean isEnableRedirection() {
        return this.enableRedirection;
    }

    public void setEnableRedirection(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
    }

    public TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException {
        return this.defaultSessionConnection.getBackupConfiguration();
    }

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException {
        return this.defaultSessionConnection.fetchAllConnections();
    }

    public static class Builder {
        private String host = "localhost";
        private int rpcPort = 6667;
        private String username = "root";
        private String password = "root";
        private int fetchSize = 5000;
        private ZoneId zoneId = null;
        private int thriftDefaultBufferSize = 1024;
        private int thriftMaxFrameSize = 0x4000000;
        private boolean enableRedirection = true;
        private Version version = SessionConfig.DEFAULT_VERSION;
        private long timeOut = 60000L;
        private List<String> nodeUrls = null;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.rpcPort = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder enableRedirection(boolean enableRedirection) {
            this.enableRedirection = enableRedirection;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder timeOut(long timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Session build() {
            if (!(this.nodeUrls == null || "localhost".equals(this.host) && this.rpcPort == 6667)) {
                throw new IllegalArgumentException("You should specify either nodeUrls or (host + rpcPort), but not both");
            }
            if (this.nodeUrls != null) {
                Session newSession = new Session(this.nodeUrls, this.username, this.password, this.fetchSize, this.zoneId, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.enableRedirection, this.version);
                newSession.setEnableQueryRedirection(true);
                return newSession;
            }
            return new Session(this.host, this.rpcPort, this.username, this.password, this.fetchSize, this.zoneId, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.enableRedirection, this.version);
        }
    }
}

