/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeExceptionType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeRuntimeCriticalException
extends PipeRuntimeException {
    public PipeRuntimeCriticalException(String message) {
        super(message);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PipeRuntimeCriticalException && Objects.equals(this.getMessage(), ((PipeRuntimeCriticalException)((Object)obj)).getMessage());
    }

    @Override
    public int hashCode() {
        return this.getMessage().hashCode();
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        PipeRuntimeExceptionType.CRITICAL_EXCEPTION.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.getMessage(), (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        PipeRuntimeExceptionType.CRITICAL_EXCEPTION.serialize(stream);
        ReadWriteIOUtils.write((String)this.getMessage(), (OutputStream)stream);
    }

    public static PipeRuntimeCriticalException deserializeFrom(ByteBuffer byteBuffer) {
        String message = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new PipeRuntimeCriticalException(message);
    }

    public static PipeRuntimeCriticalException deserializeFrom(InputStream stream) throws IOException {
        String message = ReadWriteIOUtils.readString((InputStream)stream);
        return new PipeRuntimeCriticalException(message);
    }

    public String toString() {
        return "PipeRuntimeCriticalException{ message: " + this.getMessage() + " }";
    }
}

