/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.concurrent.threadpool.IThreadPoolMBean;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ThreadPoolMetrics
implements IMetricSet {
    private static final String THREAD_POOL_ACTIVE_THREAD_COUNT = "thread_pool_active_thread_count";
    private static final String THREAD_POOL_DONE_TASK_COUNT = "thread_pool_done_task_count";
    private static final String THREAD_POOL_WAITING_TASK_COUNT = "thread_pool_waiting_task_count";
    private static final String THREAD_POOL_CORE_SIZE = "thread_pool_core_size";
    private static final String THREAD_POOL_LARGEST_POOL_SIZE = "thread_pool_largest_pool_size";
    private static final String POOL_NAME = "pool_name";
    private AbstractMetricService metricService;
    private Map<String, IThreadPoolMBean> notRegisteredPoolMap = new HashMap<String, IThreadPoolMBean>();
    private Map<String, IThreadPoolMBean> registeredPoolMap = new HashMap<String, IThreadPoolMBean>();

    public static ThreadPoolMetrics getInstance() {
        return ThreadPoolMetricsHolder.INSTANCE;
    }

    private ThreadPoolMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThreadPool(IThreadPoolMBean pool, String name) {
        ThreadPoolMetrics threadPoolMetrics = this;
        synchronized (threadPoolMetrics) {
            if (this.metricService == null) {
                this.notRegisteredPoolMap.put(name, pool);
            } else {
                this.registeredPoolMap.put(name, pool);
                this.metricService.createAutoGauge(THREAD_POOL_ACTIVE_THREAD_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getActiveCount(), new String[]{POOL_NAME, name});
                this.metricService.createAutoGauge(THREAD_POOL_CORE_SIZE, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getCorePoolSize(), new String[]{POOL_NAME, name});
                this.metricService.createAutoGauge(THREAD_POOL_WAITING_TASK_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getQueueLength(), new String[]{POOL_NAME, name});
                this.metricService.createAutoGauge(THREAD_POOL_DONE_TASK_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getCompletedTaskCount(), new String[]{POOL_NAME, name});
                this.metricService.createAutoGauge(THREAD_POOL_LARGEST_POOL_SIZE, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getLargestPoolSize(), new String[]{POOL_NAME, name});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTo(AbstractMetricService metricService) {
        ThreadPoolMetrics threadPoolMetrics = this;
        synchronized (threadPoolMetrics) {
            this.metricService = metricService;
            for (Map.Entry<String, IThreadPoolMBean> entry : this.notRegisteredPoolMap.entrySet()) {
                metricService.createAutoGauge(THREAD_POOL_ACTIVE_THREAD_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getActiveCount(), new String[]{POOL_NAME, entry.getKey()});
                metricService.createAutoGauge(THREAD_POOL_CORE_SIZE, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getCorePoolSize(), new String[]{POOL_NAME, entry.getKey()});
                metricService.createAutoGauge(THREAD_POOL_WAITING_TASK_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getQueue().size(), new String[]{POOL_NAME, entry.getKey()});
                metricService.createAutoGauge(THREAD_POOL_DONE_TASK_COUNT, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getCompletedTaskCount(), new String[]{POOL_NAME, entry.getKey()});
                metricService.createAutoGauge(THREAD_POOL_LARGEST_POOL_SIZE, MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getLargestPoolSize(), new String[]{POOL_NAME, entry.getKey()});
            }
            this.registeredPoolMap.putAll(this.notRegisteredPoolMap);
            this.notRegisteredPoolMap.clear();
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (Map.Entry<String, IThreadPoolMBean> entry : this.registeredPoolMap.entrySet()) {
            metricService.remove(MetricType.GAUGE, THREAD_POOL_ACTIVE_THREAD_COUNT, new String[]{POOL_NAME, entry.getKey()});
            metricService.remove(MetricType.GAUGE, THREAD_POOL_CORE_SIZE, new String[]{POOL_NAME, entry.getKey()});
            metricService.remove(MetricType.GAUGE, THREAD_POOL_WAITING_TASK_COUNT, new String[]{POOL_NAME, entry.getKey()});
            metricService.remove(MetricType.GAUGE, THREAD_POOL_DONE_TASK_COUNT, new String[]{POOL_NAME, entry.getKey()});
            metricService.remove(MetricType.GAUGE, THREAD_POOL_LARGEST_POOL_SIZE, new String[]{POOL_NAME, entry.getKey()});
        }
    }

    private static class ThreadPoolMetricsHolder {
        private static final ThreadPoolMetrics INSTANCE = new ThreadPoolMetrics();

        private ThreadPoolMetricsHolder() {
        }
    }
}

