/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;

public class ProcessorWithMetrics
extends IClientRPCService.Processor {
    private IClientRPCService.Iface iface;

    public ProcessorWithMetrics(IClientRPCService.Iface iface) {
        super(iface);
        this.iface = iface;
    }

    public void process(TProtocol in, TProtocol out) throws TException {
        TMessage msg = in.readMessageBegin();
        long startTime = System.nanoTime();
        ProcessFunction fn = (ProcessFunction)this.getProcessMapView().get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip((TProtocol)in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
        } else {
            fn.process(msg.seqid, in, out, (Object)this.iface);
        }
        long cost = System.nanoTime() - startTime;
        MetricService.getInstance().timer(cost, TimeUnit.NANOSECONDS, Metric.ENTRY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), msg.name});
    }
}

