/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.commons.concurrent.DataNodeThreadModule;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.ThreadPoolMetrics;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.mpp.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.mpp.metric.DataExchangeCountMetricSet;
import org.apache.iotdb.db.mpp.metric.DriverSchedulerMetricSet;
import org.apache.iotdb.db.mpp.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.mpp.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.mpp.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.mpp.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.mpp.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.service.metrics.ProcessMetrics;
import org.apache.iotdb.db.service.metrics.SystemMetrics;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.UpTimeMetrics;
import org.apache.iotdb.metrics.metricsets.cpu.CpuUsageMetrics;
import org.apache.iotdb.metrics.metricsets.disk.DiskMetrics;
import org.apache.iotdb.metrics.metricsets.jvm.JvmMetrics;
import org.apache.iotdb.metrics.metricsets.logback.LogbackMetrics;
import org.apache.iotdb.metrics.metricsets.net.NetMetrics;

public class DataNodeMetricsHelper {
    public static void bind() {
        MetricService.getInstance().addMetricSet((IMetricSet)new UpTimeMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new JvmMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)ThreadPoolMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)new LogbackMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)FileMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)CompactionMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)new ProcessMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new SystemMetrics(true));
        MetricService.getInstance().addMetricSet((IMetricSet)new DiskMetrics("datanode"));
        MetricService.getInstance().addMetricSet((IMetricSet)new NetMetrics("datanode"));
        DataNodeMetricsHelper.initCpuMetrics();
        MetricService.getInstance().addMetricSet((IMetricSet)WritingMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)QueryPlanCostMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)SeriesScanCostMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)QueryExecutionMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)QueryResourceMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)DataExchangeCostMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)DataExchangeCountMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)DriverSchedulerMetricSet.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)new QueryRelatedResourceMetricSet());
        MetricService.getInstance().addMetricSet((IMetricSet)PerformanceOverviewMetrics.getInstance());
    }

    private static void initCpuMetrics() {
        ArrayList threadModules = new ArrayList();
        Arrays.stream(DataNodeThreadModule.values()).forEach(x -> threadModules.add(x.toString()));
        ArrayList pools = new ArrayList();
        Arrays.stream(ThreadName.values()).forEach(x -> pools.add(x.name()));
        MetricService.getInstance().addMetricSet((IMetricSet)new CpuUsageMetrics(threadModules, pools, x -> ThreadName.getModuleTheThreadBelongs((String)x).toString(), x -> ThreadName.getThreadPoolTheThreadBelongs((String)x).name()));
    }
}

