/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingPendingQueue<E extends Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingPendingQueue.class);
    private static final long MAX_BLOCKING_TIME_MS = PipeConfig.getInstance().getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    private final BlockingQueue<E> pendingQueue;

    protected BlockingPendingQueue(BlockingQueue<E> pendingQueue) {
        this.pendingQueue = pendingQueue;
    }

    public boolean offer(E event) {
        boolean isAdded = false;
        try {
            isAdded = this.pendingQueue.offer(event, MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue offer is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return isAdded;
    }

    public E directPoll() {
        return (E)((Event)this.pendingQueue.poll());
    }

    public E waitedPoll() {
        Event event = null;
        try {
            event = (Event)this.pendingQueue.poll(MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue poll is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return (E)event;
    }

    public void clear() {
        this.pendingQueue.clear();
    }

    public int size() {
        return this.pendingQueue.size();
    }
}

