/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TsFileInsertionDataTabletIterator
implements Iterator<Tablet> {
    private final TsFileReader tsFileReader;
    private final Map<String, TSDataType> measurementDataTypeMap;
    private final String deviceId;
    private final List<String> measurements;
    private final IExpression timeFilterExpression;
    private final QueryDataSet queryDataSet;

    public TsFileInsertionDataTabletIterator(TsFileReader tsFileReader, Map<String, TSDataType> measurementDataTypeMap, String deviceId, List<String> measurements, IExpression timeFilterExpression) throws IOException {
        this.tsFileReader = tsFileReader;
        this.measurementDataTypeMap = measurementDataTypeMap;
        this.deviceId = deviceId;
        this.measurements = measurements.stream().filter(measurement -> measurement != null && !measurement.isEmpty()).sorted().collect(Collectors.toList());
        this.timeFilterExpression = timeFilterExpression;
        this.queryDataSet = this.buildQueryDataSet();
    }

    private QueryDataSet buildQueryDataSet() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String measurement : this.measurements) {
            paths.add(new Path(this.deviceId, measurement, false));
        }
        return this.tsFileReader.query(QueryExpression.create(paths, (IExpression)this.timeFilterExpression));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.queryDataSet.hasNext();
        }
        catch (IOException e) {
            throw new PipeException("Failed to check next", (Throwable)e);
        }
    }

    @Override
    public Tablet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.buildNextTablet();
        }
        catch (IOException e) {
            throw new PipeException("Failed to build tablet", (Throwable)e);
        }
    }

    private Tablet buildNextTablet() throws IOException {
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        for (String measurement : this.measurements) {
            TSDataType dataType = this.measurementDataTypeMap.get(this.deviceId + "." + measurement);
            schemas.add(new MeasurementSchema(measurement, dataType));
        }
        Tablet tablet = new Tablet(this.deviceId, schemas);
        tablet.initBitMaps();
        while (this.queryDataSet.hasNext()) {
            RowRecord rowRecord = this.queryDataSet.next();
            int rowIndex = tablet.rowSize;
            tablet.addTimestamp(rowIndex, rowRecord.getTimestamp());
            List fields = rowRecord.getFields();
            int fieldSize = fields.size();
            for (int i = 0; i < fieldSize; ++i) {
                Field field;
                tablet.addValue(this.measurements.get(i), rowIndex, (field = (Field)fields.get(i)) == null ? null : field.getObjectValue(field.getDataType()));
            }
            ++tablet.rowSize;
            if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
            break;
        }
        return tablet;
    }
}

