/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.legacy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.commons.lang.NotImplementedException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.connector.legacy.pipedata.TsFilePipeData;
import org.apache.iotdb.db.pipe.connector.v1.IoTDBThriftConnectorClient;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSyncConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSyncConnector.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private String ipAddress;
    private int port;
    private String user;
    private String password;
    private String syncConnectorVersion;
    private String pipeName;
    private Long creationTime;
    private IoTDBThriftConnectorClient client;
    private SessionPool sessionPool;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateRequiredAttribute("connector.ip").validateRequiredAttribute("connector.port");
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.ipAddress = parameters.getString("connector.ip");
        this.port = parameters.getInt("connector.port");
        this.user = parameters.getStringOrDefault("connector.user", "root");
        this.password = parameters.getStringOrDefault("connector.password", "root");
        this.syncConnectorVersion = parameters.getStringOrDefault("connector.version", "1.1");
        this.pipeName = configuration.getRuntimeEnvironment().getPipeName();
        this.creationTime = configuration.getRuntimeEnvironment().getCreationTime();
    }

    public void handshake() throws Exception {
        this.close();
        this.client = new IoTDBThriftConnectorClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(COMMON_CONFIG.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(COMMON_CONFIG.isRpcThriftCompressionEnabled()).build(), this.ipAddress, this.port);
        try {
            TSyncIdentityInfo identityInfo = new TSyncIdentityInfo(this.pipeName, this.creationTime.longValue(), this.syncConnectorVersion, "root");
            TSStatus status = this.client.handshake(identityInfo);
            if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                String errorMsg = String.format("The receiver %s:%s rejected the pipe task because %s", this.ipAddress, this.port, status.message);
                LOGGER.warn(errorMsg);
                throw new PipeRuntimeCriticalException(errorMsg);
            }
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Connect to receiver %s:%s error, because: %s", this.ipAddress, this.port, e.getMessage()), (Throwable)e);
        }
        this.sessionPool = new SessionPool.Builder().host(this.ipAddress).port(this.port).user(this.user).password(this.password).maxSize(1).build();
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            this.doTransfer((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
        } else if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            this.doTransfer((PipeRawTabletInsertionEvent)tabletInsertionEvent);
        } else {
            throw new NotImplementedException("IoTDBSyncConnector only support PipeInsertNodeInsertionEvent and PipeTabletInsertionEvent.");
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeInsertionEvent) throws IoTDBConnectionException, StatementExecutionException {
        Tablet tablet = pipeInsertNodeInsertionEvent.convertToTablet();
        if (pipeInsertNodeInsertionEvent.isAligned()) {
            this.sessionPool.insertAlignedTablet(tablet);
        } else {
            this.sessionPool.insertTablet(tablet);
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeTabletInsertionEvent) throws PipeException, IoTDBConnectionException, StatementExecutionException {
        Tablet tablet = pipeTabletInsertionEvent.convertToTablet();
        if (pipeTabletInsertionEvent.isAligned()) {
            this.sessionPool.insertAlignedTablet(tablet);
        } else {
            this.sessionPool.insertTablet(tablet);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            throw new NotImplementedException("IoTDBSyncConnector only support PipeTsFileInsertionEvent.");
        }
        try {
            this.doTransfer((PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Network error when transfer tsFile insertion event: %s.", tsFileInsertionEvent), (Throwable)e);
        }
    }

    private void doTransfer(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, TException, InterruptedException, IOException {
        pipeTsFileInsertionEvent.waitForTsFileClose();
        File tsFile = pipeTsFileInsertionEvent.getTsFile();
        this.transportSingleFilePieceByPiece(tsFile);
        this.client.sendPipeData(ByteBuffer.wrap(new TsFilePipeData("", tsFile.getName(), -1L).serialize()));
    }

    private void transportSingleFilePieceByPiece(File file) throws IOException {
        block11: {
            long position = 0L;
            byte[] buffer = new byte[PipeConfig.getInstance().getPipeConnectorReadFileBufferSize()];
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
                TSStatus status;
                while (true) {
                    int dataLength;
                    if ((dataLength = randomAccessFile.read(buffer)) == -1) {
                        break block11;
                    }
                    ByteBuffer buffToSend = ByteBuffer.wrap(buffer, 0, dataLength);
                    TSyncTransportMetaInfo metaInfo = new TSyncTransportMetaInfo(file.getName(), position);
                    status = this.client.sendFile(metaInfo, buffToSend);
                    if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        position += (long)dataLength;
                        continue;
                    }
                    if (status.code == TSStatusCode.SYNC_FILE_REDIRECTION_ERROR.getStatusCode()) {
                        position = Long.parseLong(status.message);
                        randomAccessFile.seek(position);
                        LOGGER.info("Redirect to position {} in transferring tsFile {}.", (Object)position, (Object)file);
                        continue;
                    }
                    if (status.code == TSStatusCode.SYNC_FILE_ERROR.getStatusCode()) break;
                }
                String errorMsg = String.format("Network failed to receive tsFile %s, status: %s", file, status);
                LOGGER.warn(errorMsg);
                throw new PipeConnectionException(errorMsg);
            }
            catch (TException e) {
                throw new PipeConnectionException(String.format("Cannot send pipe data to receiver %s:%s, because: %s.", this.ipAddress, this.port, e.getMessage()), (Throwable)e);
            }
        }
    }

    public void transfer(Event event) throws Exception {
        LOGGER.warn("IoTDBSyncConnector does not support transfer generic event: {}.", (Object)event);
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.sessionPool != null) {
            this.sessionPool.close();
            this.sessionPool = null;
        }
    }
}

