/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.task.PipeBuilder;
import org.apache.iotdb.db.pipe.task.PipeTask;
import org.apache.iotdb.db.pipe.task.PipeTaskBuilder;
import org.apache.iotdb.db.pipe.task.PipeTaskManager;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskAgent.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String MESSAGE_UNKNOWN_PIPE_STATUS = "Unknown pipe status %s for pipe %s";
    private static final String MESSAGE_UNEXPECTED_PIPE_STATUS = "Unexpected pipe status %s: ";
    private final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();
    private final PipeTaskManager pipeTaskManager = new PipeTaskManager();

    public synchronized void handlePipeMetaChanges(List<PipeMeta> pipeMetaListFromConfigNode) {
        if (PipeAgent.runtime().isShutdown()) {
            return;
        }
        ArrayList<PipeException> exceptions = new ArrayList<PipeException>();
        for (PipeMeta metaFromConfigNode : pipeMetaListFromConfigNode) {
            String pipeName = metaFromConfigNode.getStaticMeta().getPipeName();
            try {
                PipeStaticMeta staticMetaFromConfigNode;
                PipeMeta metaOnDataNode = this.pipeMetaKeeper.getPipeMeta(pipeName);
                if (metaOnDataNode == null) {
                    if (!this.createPipe(metaFromConfigNode)) continue;
                    this.startPipe(pipeName, metaFromConfigNode.getStaticMeta().getCreationTime());
                    continue;
                }
                PipeStaticMeta staticMetaOnDataNode = metaOnDataNode.getStaticMeta();
                if (!staticMetaOnDataNode.equals((Object)(staticMetaFromConfigNode = metaFromConfigNode.getStaticMeta()))) {
                    this.dropPipe(pipeName);
                    if (!this.createPipe(metaFromConfigNode)) continue;
                    this.startPipe(pipeName, metaFromConfigNode.getStaticMeta().getCreationTime());
                    continue;
                }
                PipeRuntimeMeta runtimeMetaOnDataNode = metaOnDataNode.getRuntimeMeta();
                PipeRuntimeMeta runtimeMetaFromConfigNode = metaFromConfigNode.getRuntimeMeta();
                this.handlePipeRuntimeMetaChanges(staticMetaFromConfigNode, runtimeMetaFromConfigNode, runtimeMetaOnDataNode);
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                exceptions.add(new PipeException(errorMessage, (Throwable)e));
            }
        }
        Set pipeNamesFromConfigNode = pipeMetaListFromConfigNode.stream().map(meta -> meta.getStaticMeta().getPipeName()).collect(Collectors.toSet());
        for (PipeMeta metaOnDataNode : this.pipeMetaKeeper.getPipeMetaList()) {
            String pipeName = metaOnDataNode.getStaticMeta().getPipeName();
            try {
                if (pipeNamesFromConfigNode.contains(pipeName)) continue;
                this.dropPipe(metaOnDataNode.getStaticMeta().getPipeName());
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                exceptions.add(new PipeException(errorMessage, (Throwable)e));
            }
        }
        if (!exceptions.isEmpty()) {
            throw new PipeException(String.format("Failed to handle pipe meta changes on data node, because: %s", exceptions));
        }
    }

    private void handlePipeRuntimeMetaChanges(@NotNull PipeStaticMeta pipeStaticMeta, @NotNull PipeRuntimeMeta runtimeMetaFromConfigNode, @NotNull PipeRuntimeMeta runtimeMetaOnDataNode) {
        PipeStatus statusOnDataNode;
        PipeTaskMeta taskMetaFromConfigNode;
        Map consensusGroupIdToTaskMetaMapFromConfigNode = runtimeMetaFromConfigNode.getConsensusGroupIdToTaskMetaMap();
        Map consensusGroupIdToTaskMetaMapOnDataNode = runtimeMetaOnDataNode.getConsensusGroupIdToTaskMetaMap();
        for (Map.Entry entryFromConfigNode : consensusGroupIdToTaskMetaMapFromConfigNode.entrySet()) {
            int dataNodeIdOnDataNode;
            TConsensusGroupId consensusGroupIdFromConfigNode = (TConsensusGroupId)entryFromConfigNode.getKey();
            taskMetaFromConfigNode = (PipeTaskMeta)entryFromConfigNode.getValue();
            PipeTaskMeta taskMetaOnDataNode = (PipeTaskMeta)consensusGroupIdToTaskMetaMapOnDataNode.get(consensusGroupIdFromConfigNode);
            if (taskMetaOnDataNode == null) {
                this.createPipeTask(consensusGroupIdFromConfigNode, pipeStaticMeta, taskMetaFromConfigNode);
                if (runtimeMetaOnDataNode.getStatus().get() != PipeStatus.RUNNING) continue;
                this.startPipeTask(consensusGroupIdFromConfigNode, pipeStaticMeta);
                continue;
            }
            int dataNodeIdFromConfigNode = taskMetaFromConfigNode.getLeaderDataNodeId();
            if (dataNodeIdFromConfigNode == (dataNodeIdOnDataNode = taskMetaOnDataNode.getLeaderDataNodeId())) continue;
            this.dropPipeTask(consensusGroupIdFromConfigNode, pipeStaticMeta);
            this.createPipeTask(consensusGroupIdFromConfigNode, pipeStaticMeta, taskMetaFromConfigNode);
            if (runtimeMetaOnDataNode.getStatus().get() != PipeStatus.RUNNING) continue;
            this.startPipeTask(consensusGroupIdFromConfigNode, pipeStaticMeta);
        }
        for (Map.Entry entryOnDataNode : consensusGroupIdToTaskMetaMapOnDataNode.entrySet()) {
            TConsensusGroupId consensusGroupIdOnDataNode = (TConsensusGroupId)entryOnDataNode.getKey();
            taskMetaFromConfigNode = (PipeTaskMeta)consensusGroupIdToTaskMetaMapFromConfigNode.get(consensusGroupIdOnDataNode);
            if (taskMetaFromConfigNode != null) continue;
            this.dropPipeTask(consensusGroupIdOnDataNode, pipeStaticMeta);
        }
        PipeStatus statusFromConfigNode = (PipeStatus)runtimeMetaFromConfigNode.getStatus().get();
        if (statusFromConfigNode == (statusOnDataNode = (PipeStatus)runtimeMetaOnDataNode.getStatus().get())) {
            return;
        }
        switch (statusFromConfigNode) {
            case RUNNING: {
                if (Objects.requireNonNull(statusOnDataNode) == PipeStatus.STOPPED) {
                    this.startPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, statusOnDataNode, pipeStaticMeta.getPipeName()));
            }
            case STOPPED: {
                if (Objects.requireNonNull(statusOnDataNode) == PipeStatus.RUNNING) {
                    this.stopPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, statusOnDataNode, pipeStaticMeta.getPipeName()));
            }
            case DROPPED: {
                this.dropPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                break;
            }
            default: {
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, statusFromConfigNode, pipeStaticMeta.getPipeName()));
            }
        }
    }

    public synchronized void dropAllPipeTasks() {
        for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
            try {
                this.dropPipe(pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to drop pipe {} with creation time {}", new Object[]{pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime(), e});
            }
        }
    }

    private boolean createPipe(PipeMeta pipeMetaFromConfigNode) {
        String pipeName = pipeMetaFromConfigNode.getStaticMeta().getPipeName();
        long creationTime = pipeMetaFromConfigNode.getStaticMeta().getCreationTime();
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta != null) {
            if (existedPipeMeta.getStaticMeta().getCreationTime() == creationTime) {
                PipeStatus status = (PipeStatus)existedPipeMeta.getRuntimeMeta().getStatus().get();
                switch (status) {
                    case RUNNING: 
                    case STOPPED: {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Pipe {} (creation time = {}) has already been created. Current status = {}. Skip creating.", new Object[]{pipeName, creationTime, status.name()});
                        }
                        return false;
                    }
                    case DROPPED: {
                        if (!LOGGER.isInfoEnabled()) break;
                        LOGGER.info("Pipe {} (creation time = {}) has already been dropped, but the pipe task meta has not been cleaned up. Current status = {}. Try dropping the pipe and recreating it.", new Object[]{pipeName, creationTime, status.name()});
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + ((PipeStatus)existedPipeMeta.getRuntimeMeta().getStatus().get()).name());
                    }
                }
            }
            this.dropPipe(pipeName, existedPipeMeta.getStaticMeta().getCreationTime());
        }
        Map<TConsensusGroupId, PipeTask> pipeTasks = new PipeBuilder(pipeMetaFromConfigNode).build();
        for (PipeTask pipeTask : pipeTasks.values()) {
            pipeTask.create();
        }
        this.pipeTaskManager.addPipeTasks(pipeMetaFromConfigNode.getStaticMeta(), pipeTasks);
        AtomicReference pipeStatusFromConfigNode = pipeMetaFromConfigNode.getRuntimeMeta().getStatus();
        boolean needToStartPipe = pipeStatusFromConfigNode.get() == PipeStatus.RUNNING;
        pipeStatusFromConfigNode.set(PipeStatus.STOPPED);
        this.pipeMetaKeeper.addPipeMeta(pipeName, pipeMetaFromConfigNode);
        return needToStartPipe;
    }

    private void dropPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in dropPipe request. Skip dropping.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        for (PipeTask pipeTask : pipeTasks.values()) {
            pipeTask.drop();
        }
        this.pipeMetaKeeper.removePipeMeta(pipeName);
    }

    private void dropPipe(String pipeName) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return;
        }
        for (PipeTask pipeTask : pipeTasks.values()) {
            pipeTask.drop();
        }
        this.pipeMetaKeeper.removePipeMeta(pipeName);
    }

    private void startPipe(String pipeName, long creationTime) {
        Map<TConsensusGroupId, PipeTask> pipeTasks;
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in startPipe request. Skip starting.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return;
        }
        PipeStatus status = (PipeStatus)existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("Pipe {} (creation time = {}) has been created. Current status = {}. Starting.", new Object[]{pipeName, creationTime, status.name()});
                break;
            }
            case RUNNING: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been started. Current status = {}. Skip starting.", new Object[]{pipeName, creationTime, status.name()});
                }
                return;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip starting.", new Object[]{pipeName, creationTime, status.name()});
                }
                return;
            }
            default: {
                throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + ((PipeStatus)existedPipeMeta.getRuntimeMeta().getStatus().get()).name());
            }
        }
        if ((pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta())) == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return;
        }
        for (PipeTask pipeTask : pipeTasks.values()) {
            pipeTask.start();
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.RUNNING);
        existedPipeMeta.getRuntimeMeta().getConsensusGroupIdToTaskMetaMap().values().forEach(PipeTaskMeta::clearExceptionMessages);
    }

    private void stopPipe(String pipeName, long creationTime) {
        Map<TConsensusGroupId, PipeTask> pipeTasks;
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in stopPipe request. Skip stopping.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return;
        }
        PipeStatus status = (PipeStatus)existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been stopped. Current status = {}. Skip stopping.", new Object[]{pipeName, creationTime, status.name()});
                }
                return;
            }
            case RUNNING: {
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("Pipe {} (creation time = {}) has been started. Current status = {}. Stopping.", new Object[]{pipeName, creationTime, status.name()});
                break;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip stopping.", new Object[]{pipeName, creationTime, status.name()});
                }
                return;
            }
            default: {
                throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + status.name());
            }
        }
        if ((pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta())) == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        for (PipeTask pipeTask : pipeTasks.values()) {
            pipeTask.stop();
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.STOPPED);
    }

    private void createPipeTask(TConsensusGroupId consensusGroupId, PipeStaticMeta pipeStaticMeta, PipeTaskMeta pipeTaskMeta) {
        if (pipeTaskMeta.getLeaderDataNodeId() == CONFIG.getDataNodeId()) {
            PipeTask pipeTask = new PipeTaskBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build();
            pipeTask.create();
            this.pipeTaskManager.addPipeTask(pipeStaticMeta, consensusGroupId, pipeTask);
        }
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupIdToTaskMetaMap().put(consensusGroupId, pipeTaskMeta);
    }

    private void dropPipeTask(TConsensusGroupId dataRegionGroupId, PipeStaticMeta pipeStaticMeta) {
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupIdToTaskMetaMap().remove(dataRegionGroupId);
        PipeTask pipeTask = this.pipeTaskManager.removePipeTask(pipeStaticMeta, dataRegionGroupId);
        if (pipeTask != null) {
            pipeTask.drop();
        }
    }

    private void startPipeTask(TConsensusGroupId dataRegionGroupId, PipeStaticMeta pipeStaticMeta) {
        PipeTask pipeTask = this.pipeTaskManager.getPipeTask(pipeStaticMeta, dataRegionGroupId);
        if (pipeTask != null) {
            pipeTask.start();
        }
    }

    public synchronized void collectPipeMetaList(THeartbeatReq req, THeartbeatResp resp) throws TException {
        if (PipeAgent.runtime().isShutdown() || !req.isNeedPipeMetaList()) {
            return;
        }
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        try {
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                LOGGER.info("Reporting pipe meta: {}", (Object)pipeMeta);
            }
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
    }

    public synchronized void collectPipeMetaList(TPipeHeartbeatReq req, TPipeHeartbeatResp resp) throws TException {
        if (PipeAgent.runtime().isShutdown()) {
            return;
        }
        LOGGER.info("Received pipe heartbeat request {} from config node.", (Object)req.heartbeatId);
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        try {
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                LOGGER.info("Reporting pipe meta: {}", (Object)pipeMeta);
            }
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
    }
}

