/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.component.NullOrdering;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SortItem {
    private String sortKey;
    private final Ordering ordering;
    private final NullOrdering nullOrdering;
    private Expression expression;

    public SortItem(String sortKey, Ordering ordering) {
        this(sortKey, ordering, NullOrdering.LAST);
    }

    public SortItem(String sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this.sortKey = sortKey;
        this.ordering = ordering;
        this.nullOrdering = nullOrdering;
    }

    public SortItem(Expression expression, Ordering ordering, NullOrdering nullOrdering) {
        this.expression = expression;
        this.ordering = ordering;
        this.nullOrdering = nullOrdering;
        this.sortKey = expression.getExpressionString();
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.sortKey = expression.getExpressionString();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isExpression() {
        return this.expression != null;
    }

    public SortItem reverse() {
        return new SortItem(this.getSortKey(), this.getOrdering().reverse(), this.getNullOrdering().reverse());
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.sortKey, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.ordering.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.nullOrdering.ordinal(), (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.sortKey, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.ordering.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.nullOrdering.ordinal(), (OutputStream)stream);
    }

    public static SortItem deserialize(ByteBuffer byteBuffer) {
        String sortKey = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        Ordering ordering = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        NullOrdering nullOrdering = NullOrdering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        return new SortItem(sortKey, ordering, nullOrdering);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return Objects.equals(this.sortKey, sortItem.sortKey) && this.ordering == sortItem.ordering && this.nullOrdering == sortItem.nullOrdering;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering, this.nullOrdering});
    }

    public String toSQLString() {
        return this.getSortKey() + " " + this.getOrdering().toString() + " " + this.getNullOrdering().toString();
    }
}

