/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.SinkNode;

public abstract class MultiChildrenSinkNode
extends SinkNode {
    protected List<PlanNode> children;
    protected final List<DownStreamChannelLocation> downStreamChannelLocationList;

    public MultiChildrenSinkNode(PlanNodeId id) {
        super(id);
        this.children = new ArrayList<PlanNode>();
        this.downStreamChannelLocationList = new ArrayList<DownStreamChannelLocation>();
    }

    protected MultiChildrenSinkNode(PlanNodeId id, List<PlanNode> children, List<DownStreamChannelLocation> downStreamChannelLocationList) {
        super(id);
        this.children = children;
        this.downStreamChannelLocationList = downStreamChannelLocationList;
    }

    protected MultiChildrenSinkNode(PlanNodeId id, List<DownStreamChannelLocation> downStreamChannelLocationList) {
        super(id);
        this.children = new ArrayList<PlanNode>();
        this.downStreamChannelLocationList = downStreamChannelLocationList;
    }

    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Override
    public abstract PlanNode clone();

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    public void addChildren(List<PlanNode> children) {
        this.children.addAll(children);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiChildrenSinkNode that = (MultiChildrenSinkNode)o;
        return this.children.equals(that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }

    @Override
    public void send() {
    }

    @Override
    public void close() throws Exception {
    }

    public List<DownStreamChannelLocation> getDownStreamChannelLocationList() {
        return this.downStreamChannelLocationList;
    }

    public void addDownStreamChannelLocation(DownStreamChannelLocation downStreamChannelLocation) {
        this.downStreamChannelLocationList.add(downStreamChannelLocation);
    }

    public int getCurrentLastIndex() {
        return this.children.size() - 1;
    }
}

