/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;

public abstract class MultiChildProcessNode
extends ProcessNode {
    protected List<PlanNode> children;

    protected MultiChildProcessNode(PlanNodeId id, List<PlanNode> children) {
        super(id);
        this.children = children;
    }

    protected MultiChildProcessNode(PlanNodeId id) {
        super(id);
        this.children = new ArrayList<PlanNode>();
    }

    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiChildProcessNode that = (MultiChildProcessNode)o;
        return this.children.equals(that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }
}

