/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.cartesian.CartesianProductVisitor;
import org.apache.iotdb.db.utils.TypeInferenceUtils;

public class ConcatDeviceAndBindSchemaForExpressionVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, Context context) {
        ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
        for (Expression suffixExpression : functionExpression.getExpressions()) {
            List concatedExpression = (List)this.process(suffixExpression, context);
            if (concatedExpression != null && !concatedExpression.isEmpty()) {
                extendedExpressions.add(concatedExpression);
            }
            if (!functionExpression.isBuiltInAggregationFunctionExpression()) continue;
            List<Expression> children = functionExpression.getExpressions();
            TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(functionExpression.getFunctionName(), children, extendedExpressions);
            break;
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(functionExpression, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Context context) {
        PartialPath measurement = timeSeriesOperand.getPath();
        PartialPath concatPath = context.getDevicePath().concatPath(measurement);
        List actualPaths = (List)context.getSchemaTree().searchMeasurementPaths((PartialPath)concatPath).left;
        if (actualPaths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList noStarPaths = new ArrayList(actualPaths);
        return ExpressionUtils.reconstructTimeSeriesOperands(timeSeriesOperand, noStarPaths);
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context {
        private final PartialPath devicePath;
        private final ISchemaTree schemaTree;

        public Context(PartialPath devicePath, ISchemaTree schemaTree) {
            this.devicePath = devicePath;
            this.schemaTree = schemaTree;
        }

        public PartialPath getDevicePath() {
            return this.devicePath;
        }

        public ISchemaTree getSchemaTree() {
            return this.schemaTree;
        }
    }
}

