/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class RegularExpression
extends UnaryExpression {
    private final String patternString;
    private final Pattern pattern;

    public RegularExpression(Expression expression, String patternString) {
        super(expression);
        this.patternString = patternString;
        this.pattern = Pattern.compile(patternString);
    }

    public RegularExpression(Expression expression, String patternString, Pattern pattern) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
    }

    public RegularExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.pattern = Pattern.compile((String)Validate.notNull((Object)this.patternString));
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new RegularExpression(childExpression, this.patternString, this.pattern);
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression.getExpressionString() + " REGEXP '" + this.patternString + "'";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.REGEXP;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression.getOutputSymbol() + " REGEXP '" + this.patternString + "'";
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitRegularExpression(this, context);
    }
}

