/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IsNullExpression
extends UnaryExpression {
    private final boolean isNot;

    public IsNullExpression(Expression expression, boolean isNot) {
        super(expression);
        this.isNot = isNot;
    }

    public IsNullExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public boolean isNot() {
        return this.isNot;
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression.getExpressionString() + " IS " + (this.isNot ? "NOT " : "") + "NULL";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.IS_NULL;
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new IsNullExpression(childExpression, this.isNot);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression.getOutputSymbol() + " IS " + (this.isNot ? "NOT " : "") + "NULL";
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitIsNullExpression(this, context);
    }
}

