/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.AutoCreateSchemaExecutor;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetchExecutor;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaComputationWithAutoCreation;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.NormalSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.TemplateSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ClusterSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final DataNodeSchemaCache schemaCache = DataNodeSchemaCache.getInstance();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    MPPQueryContext context = null;
    private final AutoCreateSchemaExecutor autoCreateSchemaExecutor = new AutoCreateSchemaExecutor(this.templateManager, statement -> {
        long queryId = SessionManager.getInstance().requestQueryId();
        return this.coordinator.execute((Statement)statement, queryId, null, "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold());
    });
    private final ClusterSchemaFetchExecutor clusterSchemaFetchExecutor = new ClusterSchemaFetchExecutor(this.coordinator, this.templateManager, () -> SessionManager.getInstance().requestQueryId(), (queryId, statement) -> this.coordinator.execute((Statement)statement, (long)queryId, this.context == null ? null : this.context.getSession(), "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold()), this.schemaCache::put);
    private final NormalSchemaFetcher normalSchemaFetcher = new NormalSchemaFetcher(this.schemaCache, this.autoCreateSchemaExecutor, this.clusterSchemaFetchExecutor);
    private final TemplateSchemaFetcher templateSchemaFetcher = new TemplateSchemaFetcher(this.templateManager, this.schemaCache, this.autoCreateSchemaExecutor, this.clusterSchemaFetchExecutor);

    public static ClusterSchemaFetcher getInstance() {
        return ClusterSchemaFetcherHolder.INSTANCE;
    }

    private ClusterSchemaFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterSchemaTree fetchSchema(PathPatternTree patternTree, MPPQueryContext context) {
        this.context = context;
        patternTree.constructTree();
        List pathPatternList = patternTree.getAllPathPatterns();
        ArrayList<PartialPath> explicitPathList = new ArrayList<PartialPath>();
        ArrayList<PartialPath> explicitDevicePatternList = new ArrayList<PartialPath>();
        for (PartialPath pattern : pathPatternList) {
            if (!pattern.hasWildcard()) {
                explicitPathList.add(pattern);
                continue;
            }
            if (!pattern.hasExplicitDevice() || this.templateManager.checkTemplateSetInfo(pattern) == null) continue;
            explicitDevicePatternList.add(pattern);
        }
        if (explicitPathList.size() + explicitDevicePatternList.size() < pathPatternList.size()) {
            return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, false);
        }
        this.schemaCache.takeReadLock();
        try {
            Object object;
            ClusterSchemaTree cachedSchema;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            boolean isAllCached = true;
            HashSet<String> storageGroupSet = new HashSet<String>();
            if (!explicitDevicePatternList.isEmpty()) {
                for (PartialPath explicitDevicePattern : explicitDevicePatternList) {
                    cachedSchema = this.schemaCache.getMatchedSchemaWithTemplate(explicitDevicePattern);
                    if (cachedSchema.isEmpty()) {
                        isAllCached = false;
                        break;
                    }
                    schemaTree.mergeSchemaTree(cachedSchema);
                    storageGroupSet.addAll(cachedSchema.getDatabases());
                }
            }
            if (isAllCached && !explicitPathList.isEmpty()) {
                for (PartialPath fullPath : explicitPathList) {
                    cachedSchema = this.schemaCache.get(fullPath);
                    if (cachedSchema.isEmpty()) {
                        isAllCached = false;
                        break;
                    }
                    schemaTree.mergeSchemaTree(cachedSchema);
                    storageGroupSet.addAll(cachedSchema.getDatabases());
                }
            }
            if (isAllCached) {
                schemaTree.setDatabases(storageGroupSet);
                object = schemaTree;
                return object;
            }
            object = this.clusterSchemaFetchExecutor.fetchSchemaOfPreciseMatchOrPreciseDeviceUsingTemplate(pathPatternList, patternTree);
            return object;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public ClusterSchemaTree fetchSchemaWithTags(PathPatternTree patternTree) {
        patternTree.constructTree();
        return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation) {
        this.schemaCache.takeReadLock();
        try {
            Pair<Template, PartialPath> templateSetInfo = this.templateManager.checkTemplateSetInfo(schemaComputationWithAutoCreation.getDevicePath());
            List<Integer> indexOfMissingMeasurements = templateSetInfo == null ? this.normalSchemaFetcher.processNormalTimeSeries(schemaComputationWithAutoCreation) : this.templateSchemaFetcher.processTemplateTimeSeries(templateSetInfo, schemaComputationWithAutoCreation);
            if (indexOfMissingMeasurements.isEmpty()) {
                return;
            }
            for (int index : indexOfMissingMeasurements) {
                schemaComputationWithAutoCreation.computeMeasurement(index, null);
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(List<? extends ISchemaComputationWithAutoCreation> schemaComputationWithAutoCreationList) {
        this.schemaCache.takeReadLock();
        try {
            ArrayList<ISchemaComputationWithAutoCreation> normalTimeSeriesRequestList = new ArrayList<ISchemaComputationWithAutoCreation>();
            ArrayList<ISchemaComputationWithAutoCreation> templateTimeSeriesRequestList = new ArrayList<ISchemaComputationWithAutoCreation>();
            ArrayList<Pair<Template, PartialPath>> templateSetInfoList = new ArrayList<Pair<Template, PartialPath>>();
            for (ISchemaComputationWithAutoCreation iSchemaComputationWithAutoCreation : schemaComputationWithAutoCreationList) {
                Pair<Template, PartialPath> templateSetInfo = this.templateManager.checkTemplateSetInfo(iSchemaComputationWithAutoCreation.getDevicePath());
                if (templateSetInfo == null) {
                    normalTimeSeriesRequestList.add(iSchemaComputationWithAutoCreation);
                    continue;
                }
                templateTimeSeriesRequestList.add(iSchemaComputationWithAutoCreation);
                templateSetInfoList.add(templateSetInfo);
            }
            if (!normalTimeSeriesRequestList.isEmpty()) {
                this.normalSchemaFetcher.processNormalTimeSeries(normalTimeSeriesRequestList);
            }
            if (!templateTimeSeriesRequestList.isEmpty()) {
                this.templateSchemaFetcher.processTemplateTimeSeries(templateSetInfoList, templateTimeSeriesRequestList);
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList) {
        this.schemaCache.takeReadLock();
        try {
            Object indexOfMissingMeasurements;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(devicePathList.size());
            ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
            for (int i = 0; i < devicePathList.size(); ++i) {
                schemaTree.mergeSchemaTree(this.schemaCache.get(devicePathList.get(i), measurementsList.get(i)));
                indexOfMissingMeasurements = this.checkMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add(i);
                indexOfMissingMeasurementsList.add((List<Integer>)indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                ClusterSchemaTree i = schemaTree;
                return i;
            }
            ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(devicePathList, measurementsList, indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList);
            if (!remoteSchemaTree.isEmpty()) {
                schemaTree.mergeSchemaTree(remoteSchemaTree);
            }
            if (!this.config.isAutoCreateSchemaEnabled()) {
                indexOfMissingMeasurements = schemaTree;
                return indexOfMissingMeasurements;
            }
            ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
            ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
            int size = indexOfDevicesWithMissingMeasurements.size();
            for (int i = 0; i < size; ++i) {
                int deviceIndex = (Integer)indexOfDevicesWithMissingMeasurements.get(i);
                List<Integer> indexOfMissingMeasurements2 = (List<Integer>)indexOfMissingMeasurementsList.get(i);
                indexOfMissingMeasurements2 = this.checkMissingMeasurementsAfterSchemaFetch(schemaTree, devicePathList.get(deviceIndex), indexOfMissingMeasurements2, measurementsList.get(deviceIndex));
                if (indexOfMissingMeasurements2.isEmpty()) continue;
                indexOfDevicesNeedAutoCreateSchema.add(deviceIndex);
                indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements2);
            }
            if (!indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
                this.autoCreateSchemaExecutor.autoCreateMissingMeasurements(schemaTree, devicePathList, indexOfDevicesNeedAutoCreateSchema, indexOfMeasurementsNeedAutoCreate, measurementsList, tsDataTypesList, encodingsList, compressionTypesList, isAlignedList);
            }
            ClusterSchemaTree clusterSchemaTree = schemaTree;
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath devicePath) {
        return this.templateManager.checkTemplateSetInfo(devicePath);
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetAndPreSetInfo(PartialPath timeSeriesPath, String alias) {
        return this.templateManager.checkTemplateSetAndPreSetInfo(timeSeriesPath, alias);
    }

    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        return this.templateManager.checkAllRelatedTemplate(pathPattern);
    }

    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        return this.templateManager.getAllPathsSetTemplate(templateName);
    }

    private List<Integer> checkMissingMeasurements(ISchemaTree schemaTree, PartialPath devicePath, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(i);
        }
        return indexOfMissingMeasurements;
    }

    private List<Integer> checkMissingMeasurementsAfterSchemaFetch(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, indexOfTargetMeasurements.stream().map(index -> measurements[index]).collect(Collectors.toList()));
        if (deviceSchemaInfo == null) {
            return indexOfTargetMeasurements;
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        int size = schemaList.size();
        for (int i = 0; i < size; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(indexOfTargetMeasurements.get(i));
        }
        return indexOfMissingMeasurements;
    }

    private static final class ClusterSchemaFetcherHolder {
        private static final ClusterSchemaFetcher INSTANCE = new ClusterSchemaFetcher();

        private ClusterSchemaFetcherHolder() {
        }
    }
}

