/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.Statement;

public class Analyzer {
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    public Analysis analyze(Statement statement) {
        long startTime = System.nanoTime();
        Analysis analysis = (Analysis)new AnalyzeVisitor(this.partitionFetcher, this.schemaFetcher).process(statement, this.context);
        if (statement.isQuery()) {
            QueryPlanCostMetricSet.getInstance().recordPlanCost("analyzer", System.nanoTime() - startTime);
        }
        return analysis;
    }

    public static void validate(Statement statement) {
        Analyzer analyzer = Analyzer.getAnalyzer();
        analyzer.analyze(statement);
    }

    public static Analyzer getAnalyzer() {
        return new Analyzer(new MPPQueryContext(QueryId.mockQueryId), ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance());
    }
}

