/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.weakref.jmx.internal.guava.base.Preconditions;

public class AlignedUpdateLastCacheOperator
extends AbstractUpdateLastCacheOperator {
    private final AlignedPath seriesPath;
    private final PartialPath devicePath;

    public AlignedUpdateLastCacheOperator(OperatorContext operatorContext, Operator child, AlignedPath seriesPath, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache) {
        super(operatorContext, child, dataNodeSchemaCache, needUpdateCache);
        this.seriesPath = seriesPath;
        this.devicePath = seriesPath.getDevicePath();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.child.nextWithTimer();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        Preconditions.checkArgument((res.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"last query result should only have one record");
        this.tsBlockBuilder.reset();
        int i = 0;
        while (i + 1 < res.getValueColumnCount()) {
            if (!res.getColumn(i).isNull(0)) {
                long lastTime = res.getColumn(i).getLong(0);
                TsPrimitiveType lastValue = res.getColumn(i + 1).getTsPrimitiveType(0);
                MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode((String)this.seriesPath.getMeasurementList().get(i / 2)), (IMeasurementSchema)this.seriesPath.getSchemaList().get(i / 2), Boolean.valueOf(true));
                if (this.needUpdateCache) {
                    TimeValuePair timeValuePair = new TimeValuePair(lastTime, lastValue);
                    this.lastCache.updateLastCache(this.getDatabaseName(), measurementPath, timeValuePair, false, (Long)Long.MIN_VALUE);
                }
                this.appendLastValueToTsBlockBuilder(lastTime, lastValue, measurementPath);
            }
            i += 2;
        }
        return !this.tsBlockBuilder.isEmpty() ? this.tsBlockBuilder.build() : LAST_QUERY_EMPTY_TSBLOCK;
    }

    protected void appendLastValueToTsBlockBuilder(long lastTime, TsPrimitiveType lastValue, MeasurementPath measurementPath) {
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, measurementPath.getFullPath(), lastValue.getStringValue(), measurementPath.getSeriesType().name());
    }
}

