/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation.slidingwindow;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.EmptyQueueSlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.MonotonicQueueSlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.NormalQueueSlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.SmoothQueueSlidingWindowAggregator;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class SlidingWindowAggregatorFactory {
    private static final Map<TSDataType, Comparator<Column>> maxComparators = new EnumMap<TSDataType, Comparator<Column>>(TSDataType.class);
    private static final Map<TSDataType, Comparator<Column>> minComparators = new EnumMap<TSDataType, Comparator<Column>>(TSDataType.class);
    private static final Map<TSDataType, Comparator<Column>> extremeComparators = new EnumMap<TSDataType, Comparator<Column>>(TSDataType.class);

    public static SlidingWindowAggregator createSlidingWindowAggregator(TAggregationType aggregationType, TSDataType dataType, List<Expression> inputExpressions, Map<String, String> inputAttributes, boolean ascending, List<InputLocation[]> inputLocationList, AggregationStep step) {
        Accumulator accumulator = AccumulatorFactory.createAccumulator(aggregationType, dataType, inputExpressions, inputAttributes, ascending);
        switch (aggregationType) {
            case SUM: 
            case AVG: 
            case COUNT: {
                return new SmoothQueueSlidingWindowAggregator(accumulator, inputLocationList, step);
            }
            case MAX_VALUE: {
                return new MonotonicQueueSlidingWindowAggregator(accumulator, inputLocationList, step, maxComparators.get(dataType));
            }
            case MIN_VALUE: {
                return new MonotonicQueueSlidingWindowAggregator(accumulator, inputLocationList, step, minComparators.get(dataType));
            }
            case EXTREME: {
                return new MonotonicQueueSlidingWindowAggregator(accumulator, inputLocationList, step, extremeComparators.get(dataType));
            }
            case MIN_TIME: 
            case FIRST_VALUE: {
                return !ascending ? new EmptyQueueSlidingWindowAggregator(accumulator, inputLocationList, step) : new NormalQueueSlidingWindowAggregator(accumulator, inputLocationList, step);
            }
            case MAX_TIME: 
            case LAST_VALUE: {
                return !ascending ? new NormalQueueSlidingWindowAggregator(accumulator, inputLocationList, step) : new EmptyQueueSlidingWindowAggregator(accumulator, inputLocationList, step);
            }
            case COUNT_IF: {
                throw new SemanticException("COUNT_IF with slidingWindow is not supported now");
            }
            case TIME_DURATION: {
                throw new SemanticException("TIME_DURATION with slidingWindow is not supported now");
            }
            case MODE: {
                throw new SemanticException("MODE with slidingWindow is not supported now");
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation Type: " + aggregationType);
    }

    static {
        maxComparators.put(TSDataType.INT32, Comparator.comparingInt(o -> o.getInt(0)));
        maxComparators.put(TSDataType.INT64, Comparator.comparingLong(o -> o.getLong(0)));
        maxComparators.put(TSDataType.FLOAT, Comparator.comparing(o -> Float.valueOf(o.getFloat(0))));
        maxComparators.put(TSDataType.DOUBLE, Comparator.comparingDouble(o -> o.getDouble(0)));
        minComparators.put(TSDataType.INT32, (o1, o2) -> Integer.compare(o2.getInt(0), o1.getInt(0)));
        minComparators.put(TSDataType.INT64, (o1, o2) -> Long.compare(o2.getLong(0), o1.getLong(0)));
        minComparators.put(TSDataType.FLOAT, (o1, o2) -> Float.compare(o2.getFloat(0), o1.getFloat(0)));
        minComparators.put(TSDataType.DOUBLE, (o1, o2) -> Double.compare(o2.getDouble(0), o1.getDouble(0)));
        extremeComparators.put(TSDataType.INT32, (o1, o2) -> {
            int value1 = o1.getInt(0);
            int value2 = o2.getInt(0);
            if (Math.abs(value1) > Math.abs(value2) || Math.abs(value1) == Math.abs(value2) && value1 > value2) {
                return 1;
            }
            if (value1 == value2) {
                return 0;
            }
            return -1;
        });
        extremeComparators.put(TSDataType.INT64, (o1, o2) -> {
            long value1 = o1.getLong(0);
            long value2 = o2.getLong(0);
            if (Math.abs(value1) > Math.abs(value2) || Math.abs(value1) == Math.abs(value2) && value1 > value2) {
                return 1;
            }
            if (value1 == value2) {
                return 0;
            }
            return -1;
        });
        extremeComparators.put(TSDataType.FLOAT, (o1, o2) -> {
            float value1 = o1.getFloat(0);
            float value2 = o2.getFloat(0);
            if (Math.abs(value1) > Math.abs(value2) || Math.abs(value1) == Math.abs(value2) && value1 > value2) {
                return 1;
            }
            if (value1 == value2) {
                return 0;
            }
            return -1;
        });
        extremeComparators.put(TSDataType.DOUBLE, (o1, o2) -> {
            double value1 = o1.getDouble(0);
            double value2 = o2.getDouble(0);
            if (Math.abs(value1) > Math.abs(value2) || Math.abs(value1) == Math.abs(value2) && value1 > value2) {
                return 1;
            }
            if (value1 == value2) {
                return 0;
            }
            return -1;
        });
    }
}

