/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.query.reader;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.tree.SchemaIterator;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.view.viewExpression.visitor.GetSourcePathsVisitor;
import org.apache.iotdb.db.metadata.view.viewExpression.visitor.TransformToExpressionVisitor;
import org.apache.iotdb.db.metadata.visitor.FilterContainsVisitor;
import org.apache.iotdb.db.metadata.visitor.TimeseriesFilterVisitor;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.CompleteMeasurementSchemaVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesReaderWithViewFetch
implements ISchemaReader<ITimeSeriesSchemaInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeseriesReaderWithViewFetch.class);
    private final SchemaIterator<ITimeSeriesSchemaInfo> iterator;
    private final Queue<ITimeSeriesSchemaInfo> cachedViewList = new ArrayDeque<ITimeSeriesSchemaInfo>();
    private ITimeSeriesSchemaInfo next = null;
    private boolean consumeView = false;
    private final SchemaFilter schemaFilter;
    private final boolean needFetch;
    private ListenableFuture<Boolean> isBlocked = null;
    private static final int BATCH_CACHED_SIZE = 1000;
    private static final TimeseriesFilterVisitor FILTER_VISITOR = new TimeseriesFilterVisitor();

    public TimeseriesReaderWithViewFetch(SchemaIterator<ITimeSeriesSchemaInfo> iterator, SchemaFilter schemaFilter) {
        this.iterator = iterator;
        this.schemaFilter = schemaFilter;
        this.needFetch = new FilterContainsVisitor().process(schemaFilter, SchemaFilterType.DATA_TYPE);
    }

    public TimeseriesReaderWithViewFetch(SchemaIterator<ITimeSeriesSchemaInfo> iterator, SchemaFilter schemaFilter, boolean needViewDetail) {
        this.iterator = iterator;
        this.schemaFilter = schemaFilter;
        this.needFetch = needViewDetail || new FilterContainsVisitor().process(schemaFilter, SchemaFilterType.DATA_TYPE);
    }

    @Override
    public boolean isSuccess() {
        return this.iterator.isSuccess();
    }

    @Override
    public Throwable getFailure() {
        return this.iterator.getFailure();
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    @Override
    public ListenableFuture<Boolean> isBlocked() {
        if (this.isBlocked != null) {
            return this.isBlocked;
        }
        ListenableFuture<Boolean> res = NOT_BLOCKED_FALSE;
        if (this.consumeView) {
            res = NOT_BLOCKED_TRUE;
        } else if (this.next == null) {
            while (this.iterator.hasNext()) {
                ITimeSeriesSchemaInfo temp = (ITimeSeriesSchemaInfo)this.iterator.next();
                if (this.needFetch && temp.isLogicalView()) {
                    this.cachedViewList.add(temp.snapshot());
                    if (this.cachedViewList.size() < 1000) continue;
                    res = this.asyncGetNext();
                    break;
                }
                if (!FILTER_VISITOR.process(this.schemaFilter, temp)) continue;
                this.next = temp;
                res = NOT_BLOCKED_TRUE;
                break;
            }
            if (res == NOT_BLOCKED_FALSE && !this.cachedViewList.isEmpty()) {
                res = this.asyncGetNext();
            }
        } else {
            res = NOT_BLOCKED_TRUE;
        }
        this.isBlocked = res;
        return res;
    }

    @Override
    public boolean hasNext() {
        try {
            return (Boolean)this.isBlocked().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ITimeSeriesSchemaInfo next() {
        ITimeSeriesSchemaInfo result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.consumeView) {
            result = this.next;
            this.next = null;
        } else {
            result = this.cachedViewList.poll();
            this.consumeView = !this.cachedViewList.isEmpty();
        }
        this.isBlocked = null;
        return result;
    }

    private ListenableFuture<Boolean> asyncGetNext() {
        return Futures.submit(() -> {
            this.fetchViewTimeSeriesSchemaInfo();
            if (this.consumeView) {
                return true;
            }
            while (this.iterator.hasNext()) {
                ITimeSeriesSchemaInfo temp = (ITimeSeriesSchemaInfo)this.iterator.next();
                if (temp.isLogicalView()) {
                    this.cachedViewList.add(temp.snapshot());
                    if (this.cachedViewList.size() < 1000) continue;
                    this.fetchViewTimeSeriesSchemaInfo();
                    if (!this.consumeView) continue;
                    return true;
                }
                if (!FILTER_VISITOR.process(this.schemaFilter, temp)) continue;
                this.next = temp;
                return true;
            }
            return false;
        }, (Executor)FragmentInstanceManager.getInstance().getIntoOperationExecutor());
    }

    private void fetchViewTimeSeriesSchemaInfo() {
        ArrayList<ITimeSeriesSchemaInfo> delayedLogicalViewList = new ArrayList<ITimeSeriesSchemaInfo>();
        ArrayList<ViewExpression> viewExpressionList = new ArrayList<ViewExpression>();
        GetSourcePathsVisitor getSourcePathsVisitor = new GetSourcePathsVisitor();
        PathPatternTree patternTree = new PathPatternTree();
        for (ITimeSeriesSchemaInfo series : this.cachedViewList) {
            delayedLogicalViewList.add(series);
            ViewExpression viewExpression = ((LogicalViewSchema)series.getSchema()).getExpression();
            viewExpressionList.add(((LogicalViewSchema)series.getSchema()).getExpression());
            List sourcePathsNeedFetch = (List)getSourcePathsVisitor.process(viewExpression, null);
            for (PartialPath path : sourcePathsNeedFetch) {
                patternTree.appendFullPath(path);
            }
        }
        this.cachedViewList.clear();
        ClusterSchemaTree schemaTree = ClusterSchemaFetcher.getInstance().fetchSchema(patternTree, null);
        TransformToExpressionVisitor transformToExpressionVisitor = new TransformToExpressionVisitor();
        CompleteMeasurementSchemaVisitor completeMeasurementSchemaVisitor = new CompleteMeasurementSchemaVisitor();
        HashMap<NodeRef<Expression>, TSDataType> expressionTypes = new HashMap<NodeRef<Expression>, TSDataType>();
        for (int i = 0; i < delayedLogicalViewList.size(); ++i) {
            ViewExpression viewExpression = (ViewExpression)viewExpressionList.get(i);
            Expression expression = null;
            boolean viewIsBroken = false;
            try {
                expression = transformToExpressionVisitor.process(viewExpression, null);
                expression = completeMeasurementSchemaVisitor.process(expression, schemaTree);
                ExpressionTypeAnalyzer.analyzeExpression(expressionTypes, expression);
            }
            catch (Exception e) {
                viewIsBroken = true;
            }
            ((ITimeSeriesSchemaInfo)delayedLogicalViewList.get(i)).getSchema().setType(viewIsBroken ? TSDataType.UNKNOWN : (TSDataType)expressionTypes.get(NodeRef.of(expression)));
            if (!FILTER_VISITOR.process(this.schemaFilter, (ITimeSeriesSchemaInfo)delayedLogicalViewList.get(i))) continue;
            this.cachedViewList.add((ITimeSeriesSchemaInfo)delayedLogicalViewList.get(i));
        }
        this.consumeView = !this.cachedViewList.isEmpty();
    }
}

