/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.apache.iotdb.db.metadata.mtree.store.CachedMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public class ReentrantReadOnlyCachedMTreeStore
implements IMTreeStore<ICachedMNode> {
    private final CachedMTreeStore store;
    private final long readLockStamp;

    public ReentrantReadOnlyCachedMTreeStore(CachedMTreeStore store) {
        this.store = store;
        this.readLockStamp = store.stampedReadLock();
    }

    @Override
    public ICachedMNode generatePrefix(PartialPath storageGroupPath) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public ICachedMNode getRoot() {
        return this.store.getRoot();
    }

    @Override
    public boolean hasChild(ICachedMNode parent, String name) throws MetadataException {
        return this.store.hasChild(parent, name, false);
    }

    @Override
    public ICachedMNode getChild(ICachedMNode parent, String name) throws MetadataException {
        return this.store.getChild(parent, name, false);
    }

    @Override
    public IMNodeIterator getChildrenIterator(ICachedMNode parent) throws MetadataException {
        return this.store.getChildrenIterator(parent, false);
    }

    @Override
    public IMNodeIterator<ICachedMNode> getTraverserIterator(ICachedMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        return this.store.getTraverserIterator(this, parent, templateMap, skipPreDeletedSchema);
    }

    @Override
    public ICachedMNode addChild(ICachedMNode parent, String childName, ICachedMNode child) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void deleteChild(ICachedMNode parent, String childName) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void updateMNode(ICachedMNode node) {
        this.store.updateMNode(node, false);
    }

    @Override
    public IDeviceMNode<ICachedMNode> setToEntity(ICachedMNode node) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public ICachedMNode setToInternal(IDeviceMNode<ICachedMNode> entityMNode) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void setAlias(IMeasurementMNode<ICachedMNode> measurementMNode, String alias) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void pin(ICachedMNode node) throws MetadataException {
        this.store.pin(node, false);
    }

    @Override
    public void unPin(ICachedMNode node) {
        this.store.unPin(node, false);
    }

    @Override
    public void unPinPath(ICachedMNode node) {
        this.store.unPinPath(node, false);
    }

    @Override
    public IMTreeStore<ICachedMNode> getWithReentrantReadLock() {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    public void unlockRead() {
        this.store.stampedReadUnlock(this.readLockStamp);
    }
}

