/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import java.util.Map;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.metadata.cache.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.cache.lastCache.container.LastCacheContainer;
import org.apache.iotdb.db.mpp.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SchemaCacheEntry
implements IMeasurementSchemaInfo {
    private final String storageGroup;
    private final IMeasurementSchema iMeasurementSchema;
    private final Map<String, String> tagMap;
    private final boolean isAligned;
    private volatile ILastCacheContainer lastCacheContainer = null;

    SchemaCacheEntry(String storageGroup, IMeasurementSchema iMeasurementSchema, Map<String, String> tagMap, boolean isAligned) {
        this.storageGroup = storageGroup.intern();
        this.iMeasurementSchema = iMeasurementSchema;
        this.isAligned = isAligned;
        this.tagMap = tagMap;
    }

    public String getSchemaEntryId() {
        return this.iMeasurementSchema.getMeasurementId();
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public IMeasurementSchema getIMeasurementSchema() {
        return this.iMeasurementSchema;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    public TSDataType getTsDataType() {
        return this.iMeasurementSchema.getType();
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILastCacheContainer getLastCacheContainer() {
        if (this.lastCacheContainer == null) {
            SchemaCacheEntry schemaCacheEntry = this;
            synchronized (schemaCacheEntry) {
                if (this.lastCacheContainer == null) {
                    this.lastCacheContainer = new LastCacheContainer();
                }
            }
        }
        return this.lastCacheContainer;
    }

    public void setLastCacheContainer(ILastCacheContainer lastCacheContainer) {
        this.lastCacheContainer = lastCacheContainer;
    }

    public static int estimateSize(SchemaCacheEntry schemaCacheEntry) {
        return 100 + 2 * schemaCacheEntry.getIMeasurementSchema().getMeasurementId().length();
    }

    @Override
    public String getName() {
        return this.iMeasurementSchema.getMeasurementId();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.iMeasurementSchema;
    }

    @Override
    public MeasurementSchema getSchemaAsMeasurementSchema() {
        if (this.iMeasurementSchema instanceof MeasurementSchema) {
            return (MeasurementSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public LogicalViewSchema getSchemaAsLogicalViewSchema() {
        if (this.iMeasurementSchema instanceof LogicalViewSchema) {
            return (LogicalViewSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public boolean isLogicalView() {
        return this.iMeasurementSchema.isLogicalView();
    }
}

