/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCacheMetrics;
import org.apache.iotdb.db.metadata.cache.DeviceUsingTemplateSchemaCache;
import org.apache.iotdb.db.metadata.cache.TimeSeriesSchemaCache;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final DeviceUsingTemplateSchemaCache deviceUsingTemplateSchemaCache;
    private final TimeSeriesSchemaCache timeSeriesSchemaCache;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);

    private DataNodeSchemaCache() {
        this.deviceUsingTemplateSchemaCache = new DeviceUsingTemplateSchemaCache(this.templateManager);
        this.timeSeriesSchemaCache = new TimeSeriesSchemaCache();
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeSchemaCacheMetrics(this));
    }

    public long getHitCount() {
        return this.deviceUsingTemplateSchemaCache.getHitCount() + this.timeSeriesSchemaCache.getHitCount();
    }

    public long getRequestCount() {
        return this.deviceUsingTemplateSchemaCache.getRequestCount() + this.timeSeriesSchemaCache.getRequestCount();
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public void takeReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void takeWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public ClusterSchemaTree get(PartialPath devicePath, String[] measurements) {
        return this.timeSeriesSchemaCache.get(devicePath, measurements);
    }

    public ClusterSchemaTree get(PartialPath fullPath) {
        ClusterSchemaTree clusterSchemaTree = this.deviceUsingTemplateSchemaCache.get(fullPath);
        if (clusterSchemaTree == null || clusterSchemaTree.isEmpty()) {
            return this.timeSeriesSchemaCache.get(fullPath);
        }
        return clusterSchemaTree;
    }

    public ClusterSchemaTree getMatchedSchemaWithTemplate(PartialPath path) {
        return this.deviceUsingTemplateSchemaCache.getMatchedSchemaWithTemplate(path);
    }

    public List<Integer> computeWithoutTemplate(ISchemaComputation schemaComputation) {
        List<Integer> result = this.timeSeriesSchemaCache.computeAndRecordLogicalView(schemaComputation);
        schemaComputation.recordRangeOfLogicalViewSchemaListNow();
        return result;
    }

    public Pair<List<Integer>, List<String>> computeSourceOfLogicalView(ISchemaComputation schemaComputation) {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        return this.timeSeriesSchemaCache.computeSourceOfLogicalView(schemaComputation);
    }

    public List<Integer> computeWithTemplate(ISchemaComputation schemaComputation) {
        return this.deviceUsingTemplateSchemaCache.compute(schemaComputation);
    }

    public void put(ClusterSchemaTree tree) {
        HashSet<PartialPath> templateDevices = new HashSet<PartialPath>();
        HashSet<PartialPath> commonDevices = new HashSet<PartialPath>();
        for (MeasurementPath path : tree.getAllMeasurement()) {
            PartialPath devicePath = path.getDevicePath();
            if (templateDevices.contains(devicePath)) continue;
            if (commonDevices.contains(devicePath)) {
                this.timeSeriesSchemaCache.putSingleMeasurementPath(tree.getBelongedDatabase((PartialPath)path), path);
                continue;
            }
            Optional<Pair<Template, PartialPath>> templateInfo = Optional.ofNullable(this.templateManager.checkTemplateSetInfo(devicePath));
            if (templateInfo.isPresent()) {
                this.deviceUsingTemplateSchemaCache.put(devicePath, tree.getBelongedDatabase(devicePath), ((Template)templateInfo.get().left).getId());
                templateDevices.add(devicePath);
                continue;
            }
            this.timeSeriesSchemaCache.putSingleMeasurementPath(tree.getBelongedDatabase((PartialPath)path), path);
            commonDevices.add(devicePath);
        }
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        return this.timeSeriesSchemaCache.getLastCache(seriesPath);
    }

    public void updateLastCache(PartialPath devicePath, String measurement, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.timeSeriesSchemaCache.updateLastCache(devicePath, measurement, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void updateLastCache(String database, PartialPath devicePath, String[] measurements, MeasurementSchema[] measurementSchemas, boolean isAligned, Function<Integer, TimeValuePair> timeValuePairProvider, Function<Integer, Boolean> shouldUpdateProvider, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.timeSeriesSchemaCache.updateLastCache(database, devicePath, measurements, measurementSchemas, isAligned, timeValuePairProvider, shouldUpdateProvider, highPriorityUpdate, latestFlushedTime);
    }

    public void updateLastCache(String storageGroup, MeasurementPath measurementPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.timeSeriesSchemaCache.updateLastCache(storageGroup, measurementPath, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void invalidateAll() {
        this.deviceUsingTemplateSchemaCache.invalidateCache();
        this.timeSeriesSchemaCache.invalidateAll();
    }

    public void cleanUp() {
        this.deviceUsingTemplateSchemaCache.invalidateCache();
        this.timeSeriesSchemaCache.invalidateAll();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }
}

