/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata.template;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.rpc.TSStatusCode;

public class TemplateImcompatibeException
extends MetadataException {
    public TemplateImcompatibeException(String path, String templateName, PartialPath templateSetPath) {
        super(String.format("Cannot create timeseries [%s] since schema template [%s] already set on path [%s].", path, templateName, templateSetPath), TSStatusCode.TEMPLATE_INCOMPATIBLE.getStatusCode());
        this.isUserException = true;
    }

    public TemplateImcompatibeException(String templateName, PartialPath templateSetPath) {
        super(String.format("Cannot set schema template [%s] to path [%s] since there's timeseries under path [%s].", templateName, templateSetPath, templateSetPath), TSStatusCode.TEMPLATE_INCOMPATIBLE.getStatusCode());
        this.isUserException = true;
    }

    public TemplateImcompatibeException(String reason) {
        super(reason, TSStatusCode.TEMPLATE_INCOMPATIBLE.getStatusCode());
        this.isUserException = true;
    }
}

