/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.performer.constant;

import org.apache.iotdb.db.engine.compaction.execute.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.impl.ReadChunkCompactionPerformer;

public enum InnerSeqCompactionPerformer {
    READ_CHUNK,
    FAST;


    public static InnerSeqCompactionPerformer getInnerSeqCompactionPerformer(String name) {
        if (READ_CHUNK.toString().equalsIgnoreCase(name)) {
            return READ_CHUNK;
        }
        if (FAST.toString().equalsIgnoreCase(name)) {
            return FAST;
        }
        throw new RuntimeException("Illegal compaction performer for seq inner compaction " + name);
    }

    public ISeqCompactionPerformer createInstance() {
        switch (this) {
            case READ_CHUNK: {
                return new ReadChunkCompactionPerformer();
            }
            case FAST: {
                return new FastCompactionPerformer(false);
            }
        }
        throw new RuntimeException("Illegal compaction performer for seq inner compaction " + (Object)((Object)this));
    }
}

