/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common.response;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.common.response.ConsensusResponse;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;

public class ConsensusWriteResponse
extends ConsensusResponse {
    private final TSStatus status;

    public ConsensusWriteResponse(ConsensusException exception, TSStatus status) {
        super(exception);
        this.status = status;
    }

    public TSStatus getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "ConsensusWriteResponse{status=" + this.status + "} " + super.toString();
    }

    public boolean isSuccessful() {
        return this.status != null && this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    public String getErrorMessage() {
        if (this.status != null && this.status.message != null && this.status.message.length() > 0) {
            return this.status.message;
        }
        if (this.exception != null && this.exception.getMessage() != null && this.exception.getMessage().length() > 0) {
            return this.exception.getMessage();
        }
        return "unknown error message";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TSStatus status;
        private ConsensusException exception;

        public ConsensusWriteResponse build() {
            return new ConsensusWriteResponse(this.exception, this.status);
        }

        public Builder setException(ConsensusException exception) {
            this.exception = exception;
            return this;
        }

        public Builder setStatus(TSStatus status) {
            this.status = status;
            return this;
        }
    }
}

