/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperatePipeProcedureV2
extends AbstractNodeProcedure<OperatePipeTaskState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatePipeProcedureV2.class);
    private static final int RETRY_THRESHOLD = 1;
    protected boolean isRollbackFromOperateOnDataNodesSuccessful = false;

    protected abstract PipeTaskOperation getOperation();

    protected abstract void executeFromValidateTask(ConfigNodeProcedureEnv var1) throws PipeException;

    protected abstract void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv var1) throws PipeException;

    protected abstract void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1) throws PipeException;

    protected abstract void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws PipeException, IOException;

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block9: {
            try {
                switch (state) {
                    case VALIDATE_TASK: {
                        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().lock();
                        this.executeFromValidateTask(env);
                        this.setNextState(OperatePipeTaskState.CALCULATE_INFO_FOR_TASK);
                        break;
                    }
                    case CALCULATE_INFO_FOR_TASK: {
                        this.executeFromCalculateInfoForTask(env);
                        this.setNextState(OperatePipeTaskState.WRITE_CONFIG_NODE_CONSENSUS);
                        break;
                    }
                    case WRITE_CONFIG_NODE_CONSENSUS: {
                        this.executeFromWriteConfigNodeConsensus(env);
                        this.setNextState(OperatePipeTaskState.OPERATE_ON_DATA_NODES);
                        break;
                    }
                    case OPERATE_ON_DATA_NODES: {
                        this.executeFromOperateOnDataNodes(env);
                        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in OperatePipeProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to {} at state [{}]", new Object[]{this.getOperation(), state, e});
                if (this.getCycles() <= 1) break block9;
                this.setFailure(new ProcedureException(String.format("Fail to %s because %s", this.getOperation().name(), e.getMessage())));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeTaskState state) {
        return true;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case VALIDATE_TASK: {
                try {
                    this.rollbackFromValidateTask(env);
                    break;
                }
                finally {
                    env.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                }
            }
            case CALCULATE_INFO_FOR_TASK: {
                this.rollbackFromCalculateInfoForTask(env);
                break;
            }
            case WRITE_CONFIG_NODE_CONSENSUS: {
                if (this.isRollbackFromOperateOnDataNodesSuccessful) break;
                this.rollbackFromWriteConfigNodeConsensus(env);
                break;
            }
            case OPERATE_ON_DATA_NODES: {
                this.rollbackFromWriteConfigNodeConsensus(env);
                this.rollbackFromOperateOnDataNodes(env);
                this.isRollbackFromOperateOnDataNodesSuccessful = true;
                break;
            }
            default: {
                LOGGER.error("Unsupported roll back STATE [{}]", (Object)state);
            }
        }
    }

    protected abstract void rollbackFromValidateTask(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws IOException;

    @Override
    protected OperatePipeTaskState getState(int stateId) {
        return OperatePipeTaskState.values()[stateId];
    }

    @Override
    protected int getStateId(OperatePipeTaskState state) {
        return state.ordinal();
    }

    @Override
    protected OperatePipeTaskState getInitialState() {
        return OperatePipeTaskState.VALIDATE_TASK;
    }

    protected TSStatus pushPipeMetaToDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : env.getConfigManager().getPipeManager().getPipeTaskCoordinator().getPipeTaskInfo().getPipeMetaList()) {
            pipeMetaBinaryList.add(pipeMeta.serialize());
        }
        return RpcUtils.squashResponseStatusList(env.pushPipeMetaToDataNodes(pipeMetaBinaryList));
    }

    protected void pushPipeMetaToDataNodesIgnoreException(ConfigNodeProcedureEnv env) {
        try {
            this.pushPipeMetaToDataNodes(env);
        }
        catch (Throwable throwable) {
            LOGGER.info("Failed to push pipe meta list to data nodes, will retry later.", throwable);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isRollbackFromOperateOnDataNodesSuccessful, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.isRollbackFromOperateOnDataNodesSuccessful = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

