/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.cq;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.cq.TimeoutPolicy;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.cq.UpdateCQLastExecTimePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.mpp.rpc.thrift.TExecuteCQ;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQScheduleTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQScheduleTask.class);
    private static final long DEFAULT_RETRY_WAIT_TIME_IN_MS = 20000L;
    private static final long FACTOR;
    private final String cqId;
    private final long everyInterval;
    private final long startTimeOffset;
    private final long endTimeOffset;
    private final TimeoutPolicy timeoutPolicy;
    private final String queryBody;
    private final String md5;
    private final String zoneId;
    private final String username;
    private final ScheduledExecutorService executor;
    private final ConfigManager configManager;
    private final long retryWaitTimeInMS;
    private long executionTime;

    public CQScheduleTask(TCreateCQReq req, long firstExecutionTime, String md5, ScheduledExecutorService executor, ConfigManager configManager) {
        this(req.cqId, req.everyInterval, req.startTimeOffset, req.endTimeOffset, TimeoutPolicy.deserialize((byte)req.timeoutPolicy), req.queryBody, md5, req.zoneId, req.username, executor, configManager, firstExecutionTime);
    }

    public CQScheduleTask(CQInfo.CQEntry entry, ScheduledExecutorService executor, ConfigManager configManager) {
        this(entry.getCqId(), entry.getEveryInterval(), entry.getStartTimeOffset(), entry.getEndTimeOffset(), entry.getTimeoutPolicy(), entry.getQueryBody(), entry.getMd5(), entry.getZoneId(), entry.getUsername(), executor, configManager, entry.getLastExecutionTime() + entry.getEveryInterval());
    }

    public CQScheduleTask(String cqId, long everyInterval, long startTimeOffset, long endTimeOffset, TimeoutPolicy timeoutPolicy, String queryBody, String md5, String zoneId, String username, ScheduledExecutorService executor, ConfigManager configManager, long executionTime) {
        this.cqId = cqId;
        this.everyInterval = everyInterval;
        this.startTimeOffset = startTimeOffset;
        this.endTimeOffset = endTimeOffset;
        this.timeoutPolicy = timeoutPolicy;
        this.queryBody = queryBody;
        this.md5 = md5;
        this.zoneId = zoneId;
        this.username = username;
        this.executor = executor;
        this.configManager = configManager;
        this.retryWaitTimeInMS = Math.min(20000L, everyInterval / FACTOR);
        this.executionTime = executionTime;
    }

    public static long getFirstExecutionTime(long boundaryTime, long everyInterval) {
        long now = System.currentTimeMillis() * FACTOR;
        return CQScheduleTask.getFirstExecutionTime(boundaryTime, everyInterval, now);
    }

    public static long getFirstExecutionTime(long boundaryTime, long everyInterval, long now) {
        if (now <= boundaryTime) {
            return boundaryTime;
        }
        return ((now - boundaryTime - 1L) / everyInterval + 1L) * everyInterval + boundaryTime;
    }

    @Override
    public void run() {
        block5: {
            long startTime = this.executionTime - this.startTimeOffset;
            long endTime = this.executionTime - this.endTimeOffset;
            Optional<TDataNodeLocation> targetDataNode = this.configManager.getNodeManager().getLowestLoadDataNode();
            if (!targetDataNode.isPresent()) {
                LOGGER.warn("There is no RUNNING DataNode to execute CQ {}", (Object)this.cqId);
                if (this.needSubmit()) {
                    this.submitSelf(this.retryWaitTimeInMS, TimeUnit.MILLISECONDS);
                }
            } else {
                LOGGER.info("[StartExecuteCQ] execute CQ {} on DataNode[{}], time range is [{}, {}), current time is {}", new Object[]{this.cqId, targetDataNode.get().dataNodeId, startTime, endTime, System.currentTimeMillis() * FACTOR});
                TExecuteCQ executeCQReq = new TExecuteCQ(this.queryBody, startTime, endTime, this.everyInterval, this.zoneId, this.cqId, this.username);
                try {
                    AsyncDataNodeInternalServiceClient client = AsyncDataNodeClientPool.getInstance().getAsyncClient(targetDataNode.get());
                    client.executeCQ(executeCQReq, (AsyncMethodCallback)new AsyncExecuteCQCallback(startTime, endTime));
                }
                catch (Throwable t) {
                    LOGGER.warn("Execute CQ {} failed", (Object)this.cqId, (Object)t);
                    if (!this.needSubmit()) break block5;
                    this.submitSelf(this.retryWaitTimeInMS, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public void submitSelf() {
        this.submitSelf(Math.max(0L, this.executionTime / FACTOR - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
    }

    private boolean needSubmit() {
        return this.configManager.getConsensusManager().isLeader() && !this.executor.isShutdown();
    }

    private void submitSelf(long delay, TimeUnit unit) {
        this.executor.schedule(this, delay, unit);
    }

    static {
        String timestampPrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision();
        FACTOR = "us".equals(timestampPrecision) ? 1000L : ("ns".equals(timestampPrecision) ? 1000000L : 1L);
    }

    private class AsyncExecuteCQCallback
    implements AsyncMethodCallback<TSStatus> {
        private final long startTime;
        private final long endTime;

        public AsyncExecuteCQCallback(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        private void updateExecutionTime() {
            if (CQScheduleTask.this.timeoutPolicy == TimeoutPolicy.BLOCKED) {
                CQScheduleTask.this.executionTime = CQScheduleTask.this.executionTime + CQScheduleTask.this.everyInterval;
            } else if (CQScheduleTask.this.timeoutPolicy == TimeoutPolicy.DISCARD) {
                long now = System.currentTimeMillis() * FACTOR;
                CQScheduleTask.this.executionTime = CQScheduleTask.this.executionTime + ((now - CQScheduleTask.this.executionTime - 1L) / CQScheduleTask.this.everyInterval + 1L) * CQScheduleTask.this.everyInterval;
            } else {
                throw new IllegalArgumentException("Unknown TimeoutPolicy: " + CQScheduleTask.this.timeoutPolicy);
            }
        }

        public void onComplete(TSStatus response) {
            if (response.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("[EndExecuteCQ] {}, time range is [{}, {}), current time is {}", new Object[]{CQScheduleTask.this.cqId, this.startTime, this.endTime, System.currentTimeMillis() * FACTOR});
                ConsensusWriteResponse result = CQScheduleTask.this.configManager.getConsensusManager().write(new UpdateCQLastExecTimePlan(CQScheduleTask.this.cqId, CQScheduleTask.this.executionTime, CQScheduleTask.this.md5));
                if (!result.isSuccessful()) {
                    LOGGER.warn("Failed to update the last execution time {} of CQ {}, because {}", new Object[]{CQScheduleTask.this.executionTime, CQScheduleTask.this.cqId, result.getErrorMessage()});
                    if (result.getStatus() != null && result.getStatus().code == TSStatusCode.NO_SUCH_CQ.getStatusCode()) {
                        LOGGER.info("Stop submitting CQ {} because {}", (Object)CQScheduleTask.this.cqId, (Object)result.getStatus().message);
                        return;
                    }
                }
                if (CQScheduleTask.this.needSubmit()) {
                    this.updateExecutionTime();
                    CQScheduleTask.this.submitSelf();
                } else {
                    LOGGER.info("Stop submitting CQ {} because current node is not leader or current scheduled thread pool is shut down.", (Object)CQScheduleTask.this.cqId);
                }
            } else {
                LOGGER.warn("Execute CQ {} failed, TSStatus is {}", (Object)CQScheduleTask.this.cqId, (Object)response);
                if (CQScheduleTask.this.needSubmit()) {
                    CQScheduleTask.this.submitSelf(CQScheduleTask.this.retryWaitTimeInMS, TimeUnit.MILLISECONDS);
                }
            }
        }

        public void onError(Exception exception) {
            LOGGER.warn("Execute CQ {} failed", (Object)CQScheduleTask.this.cqId, (Object)exception);
            if (CQScheduleTask.this.needSubmit()) {
                CQScheduleTask.this.submitSelf(CQScheduleTask.this.retryWaitTimeInMS, TimeUnit.MILLISECONDS);
            }
        }
    }
}

