/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFailedTasksThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryFailedTasksThread.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final NodeManager nodeManager;
    private final LoadManager loadManager;
    private final ScheduledExecutorService retryFailTasksExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Cluster-RetryFailedTasks-Service");
    private final Object scheduleMonitor = new Object();
    private Future<?> currentFailedTasksRetryThreadFuture;
    private final Set<TDataNodeLocation> oldUnknownNodes;

    public RetryFailedTasksThread(IManager configManager) {
        this.configManager = configManager;
        this.nodeManager = configManager.getNodeManager();
        this.loadManager = configManager.getLoadManager();
        this.oldUnknownNodes = new HashSet<TDataNodeLocation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRetryFailedTasksService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentFailedTasksRetryThreadFuture == null) {
                this.currentFailedTasksRetryThreadFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.retryFailTasksExecutor, this::retryFailedTasks, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("RetryFailMissions service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRetryFailedTasksService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentFailedTasksRetryThreadFuture != null) {
                this.currentFailedTasksRetryThreadFuture.cancel(false);
                this.currentFailedTasksRetryThreadFuture = null;
                LOGGER.info("RetryFailMissions service is stopped successfully.");
            }
        }
    }

    private void retryFailedTasks() {
        this.triggerDetectTask();
    }

    private void triggerDetectTask() {
        TSStatus transferResult;
        ArrayList<TDataNodeLocation> newUnknownNodes = new ArrayList<TDataNodeLocation>();
        this.nodeManager.getRegisteredDataNodes().forEach(DataNodeConfiguration -> {
            TDataNodeLocation dataNodeLocation = DataNodeConfiguration.getLocation();
            NodeStatus nodeStatus = this.loadManager.getNodeStatus(dataNodeLocation.getDataNodeId());
            if (nodeStatus == NodeStatus.Running) {
                this.oldUnknownNodes.remove(dataNodeLocation);
            } else if (!this.oldUnknownNodes.contains(dataNodeLocation) && nodeStatus == NodeStatus.Unknown) {
                newUnknownNodes.add(dataNodeLocation);
            }
        });
        if (!newUnknownNodes.isEmpty() && (transferResult = this.configManager.transfer(newUnknownNodes)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.oldUnknownNodes.addAll(newUnknownNodes);
        }
    }
}

