/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.partition.RegionGroupExtensionPolicy;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final ConfigNodeConfig conf = new ConfigNodeConfig();

    private ConfigNodeDescriptor() {
        this.loadProps();
    }

    public ConfigNodeConfig getConf() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getPropsUrl(String configFileName) {
        String urlString = System.getProperty("CONFIGNODE_CONF", null);
        if (urlString == null) {
            urlString = System.getProperty("CONFIGNODE_HOME", null);
            if (urlString == null) return null;
            urlString = urlString + File.separatorChar + "conf" + File.separatorChar + configFileName;
        } else if (!urlString.endsWith(".properties")) {
            urlString = urlString + File.separatorChar + configFileName;
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        InputStream inputStream;
        URL url = this.getPropsUrl("iotdb-common.properties");
        Properties commonProperties = new Properties();
        if (url != null) {
            try {
                inputStream = url.openStream();
                try {
                    LOGGER.info("Start to read config file {}", (Object)url);
                    commonProperties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Fail to find config file {}", (Object)url, (Object)e);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot load config file, use default configuration", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Incorrect format in config file, use default configuration", (Throwable)e);
            }
        } else {
            LOGGER.warn("Couldn't load the configuration {} from any of the known sources.", (Object)"iotdb-common.properties");
        }
        url = this.getPropsUrl("iotdb-confignode.properties");
        if (url != null) {
            try {
                inputStream = url.openStream();
                try {
                    LOGGER.info("start reading ConfigNode conf file: {}", (Object)url);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    commonProperties.putAll((Map<?, ?>)properties);
                    this.loadProperties(commonProperties);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException | BadNodeUrlException e) {
                LOGGER.warn("Couldn't load ConfigNode conf file, use default config", e);
            }
            finally {
                this.conf.updatePath();
                this.commonDescriptor.getConfig().updatePath(System.getProperty("CONFIGNODE_HOME", null));
                MetricConfigDescriptor.getInstance().loadProps(commonProperties);
                MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getClusterName(), NodeType.CONFIGNODE, "root.__system");
            }
        } else {
            LOGGER.warn("Couldn't load the configuration {} from any of the known sources.", (Object)"iotdb-confignode.properties");
        }
    }

    private void loadProperties(Properties properties) throws BadNodeUrlException, IOException {
        this.conf.setClusterName(properties.getProperty("cluster_name", this.conf.getClusterName()).trim());
        this.conf.setInternalAddress(properties.getProperty("cn_internal_address", this.conf.getInternalAddress()).trim());
        this.conf.setInternalPort(Integer.parseInt(properties.getProperty("cn_internal_port", String.valueOf(this.conf.getInternalPort())).trim()));
        this.conf.setConsensusPort(Integer.parseInt(properties.getProperty("cn_consensus_port", String.valueOf(this.conf.getConsensusPort())).trim()));
        String targetConfigNodes = properties.getProperty("cn_target_config_node_list", null);
        if (targetConfigNodes != null) {
            this.conf.setTargetConfigNode(NodeUrlUtils.parseTEndPointUrl((String)targetConfigNodes.trim()));
        }
        this.conf.setSeriesSlotNum(Integer.parseInt(properties.getProperty("series_slot_num", String.valueOf(this.conf.getSeriesSlotNum())).trim()));
        this.conf.setSeriesPartitionExecutorClass(properties.getProperty("series_partition_executor_class", this.conf.getSeriesPartitionExecutorClass()).trim());
        this.conf.setConfigNodeConsensusProtocolClass(properties.getProperty("config_node_consensus_protocol_class", this.conf.getConfigNodeConsensusProtocolClass()).trim());
        this.conf.setSchemaRegionConsensusProtocolClass(properties.getProperty("schema_region_consensus_protocol_class", this.conf.getSchemaRegionConsensusProtocolClass()).trim());
        this.conf.setSchemaReplicationFactor(Integer.parseInt(properties.getProperty("schema_replication_factor", String.valueOf(this.conf.getSchemaReplicationFactor())).trim()));
        this.conf.setDataRegionConsensusProtocolClass(properties.getProperty("data_region_consensus_protocol_class", this.conf.getDataRegionConsensusProtocolClass()).trim());
        this.conf.setDataReplicationFactor(Integer.parseInt(properties.getProperty("data_replication_factor", String.valueOf(this.conf.getDataReplicationFactor())).trim()));
        this.conf.setSchemaRegionGroupExtensionPolicy(RegionGroupExtensionPolicy.parse(properties.getProperty("schema_region_group_extension_policy", this.conf.getSchemaRegionGroupExtensionPolicy().getPolicy().trim())));
        this.conf.setDefaultSchemaRegionGroupNumPerDatabase(Integer.parseInt(properties.getProperty("default_schema_region_group_num_per_database", String.valueOf(this.conf.getDefaultSchemaRegionGroupNumPerDatabase())).trim()));
        this.conf.setSchemaRegionPerDataNode(Double.parseDouble(properties.getProperty("schema_region_per_data_node", String.valueOf(this.conf.getSchemaReplicationFactor())).trim()));
        this.conf.setDataRegionGroupExtensionPolicy(RegionGroupExtensionPolicy.parse(properties.getProperty("data_region_group_extension_policy", this.conf.getDataRegionGroupExtensionPolicy().getPolicy().trim())));
        this.conf.setDefaultDataRegionGroupNumPerDatabase(Integer.parseInt(properties.getProperty("default_data_region_group_num_per_database", String.valueOf(this.conf.getDefaultDataRegionGroupNumPerDatabase()).trim())));
        this.conf.setDataRegionPerDataNode(Double.parseDouble(properties.getProperty("data_region_per_data_node", String.valueOf(this.conf.getDataRegionPerDataNode())).trim()));
        try {
            this.conf.setRegionAllocateStrategy(RegionBalancer.RegionGroupAllocatePolicy.valueOf(properties.getProperty("region_group_allocate_policy", this.conf.getRegionGroupAllocatePolicy().name()).trim()));
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("The configured region allocate strategy does not exist, use the default: GREEDY!");
        }
        this.conf.setEnableDataPartitionInheritPolicy(Boolean.parseBoolean(properties.getProperty("enable_data_partition_inherit_policy", String.valueOf(this.conf.isEnableDataPartitionInheritPolicy()))));
        this.conf.setCnRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("cn_rpc_advanced_compression_enable", String.valueOf(this.conf.isCnRpcAdvancedCompressionEnable())).trim()));
        this.conf.setCnRpcMaxConcurrentClientNum(Integer.parseInt(properties.getProperty("cn_rpc_max_concurrent_client_num", String.valueOf(this.conf.getCnRpcMaxConcurrentClientNum())).trim()));
        this.conf.setCnThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("cn_thrift_init_buffer_size", String.valueOf(this.conf.getCnThriftDefaultBufferSize())).trim()));
        this.conf.setCnThriftMaxFrameSize(Integer.parseInt(properties.getProperty("cn_thrift_max_frame_size", String.valueOf(this.conf.getCnThriftMaxFrameSize())).trim()));
        this.conf.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.conf.getCoreClientNumForEachNode())).trim()));
        this.conf.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.conf.getMaxClientNumForEachNode())).trim()));
        this.conf.setSystemDir(properties.getProperty("cn_system_dir", this.conf.getSystemDir()).trim());
        this.conf.setConsensusDir(properties.getProperty("cn_consensus_dir", this.conf.getConsensusDir()).trim());
        this.conf.setUdfDir(properties.getProperty("udf_lib_dir", this.conf.getUdfDir()).trim());
        this.conf.setTriggerDir(properties.getProperty("trigger_lib_dir", this.conf.getTriggerDir()).trim());
        this.conf.setPipeDir(properties.getProperty("pipe_lib_dir", this.conf.getPipeDir()).trim());
        this.conf.setHeartbeatIntervalInMs(Long.parseLong(properties.getProperty("heartbeat_interval_in_ms", String.valueOf(this.conf.getHeartbeatIntervalInMs())).trim()));
        String leaderDistributionPolicy = properties.getProperty("leader_distribution_policy", this.conf.getLeaderDistributionPolicy()).trim();
        if (!"GREEDY".equals(leaderDistributionPolicy) && !"MIN_COST_FLOW".equals(leaderDistributionPolicy)) {
            throw new IOException(String.format("Unknown leader_distribution_policy: %s, please set to \"GREEDY\" or \"MIN_COST_FLOW\"", leaderDistributionPolicy));
        }
        this.conf.setLeaderDistributionPolicy(leaderDistributionPolicy);
        this.conf.setEnableAutoLeaderBalanceForRatisConsensus(Boolean.parseBoolean(properties.getProperty("enable_auto_leader_balance_for_ratis_consensus", String.valueOf(this.conf.isEnableAutoLeaderBalanceForRatisConsensus())).trim()));
        this.conf.setEnableAutoLeaderBalanceForIoTConsensus(Boolean.parseBoolean(properties.getProperty("enable_auto_leader_balance_for_iot_consensus", String.valueOf(this.conf.isEnableAutoLeaderBalanceForIoTConsensus())).trim()));
        String routePriorityPolicy = properties.getProperty("route_priority_policy", this.conf.getRoutePriorityPolicy()).trim();
        if (!"GREEDY".equals(routePriorityPolicy) && !"LEADER".equals(routePriorityPolicy)) {
            throw new IOException(String.format("Unknown route_priority_policy: %s, please set to \"LEADER\" or \"GREEDY\"", routePriorityPolicy));
        }
        this.conf.setRoutePriorityPolicy(routePriorityPolicy);
        String readConsistencyLevel = properties.getProperty("read_consistency_level", this.conf.getReadConsistencyLevel()).trim();
        if (!readConsistencyLevel.equals("strong") && !readConsistencyLevel.equals("weak")) {
            throw new IOException(String.format("Unknown read_consistency_level: %s, please set to \"strong\" or \"weak\"", readConsistencyLevel));
        }
        this.conf.setReadConsistencyLevel(readConsistencyLevel);
        this.commonDescriptor.loadCommonProps(properties);
        this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
        this.conf.setProcedureCompletedEvictTTL(Integer.parseInt(properties.getProperty("procedure_completed_evict_ttl", String.valueOf(this.conf.getProcedureCompletedEvictTTL())).trim()));
        this.conf.setProcedureCompletedCleanInterval(Integer.parseInt(properties.getProperty("procedure_completed_clean_interval", String.valueOf(this.conf.getProcedureCompletedCleanInterval())).trim()));
        this.conf.setProcedureCoreWorkerThreadsCount(Integer.parseInt(properties.getProperty("procedure_core_worker_thread_count", String.valueOf(this.conf.getProcedureCoreWorkerThreadsCount())).trim()));
        this.loadRatisConsensusConfig(properties);
        this.loadCQConfig(properties);
    }

    private void loadRatisConsensusConfig(Properties properties) {
        this.conf.setDataRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("data_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getDataRegionRatisConsensusLogAppenderBufferSize())).trim()));
        this.conf.setConfigNodeRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("config_node_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getConfigNodeRatisConsensusLogAppenderBufferSize())).trim()));
        this.conf.setSchemaRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("schema_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getSchemaRegionRatisConsensusLogAppenderBufferSize())).trim()));
        this.conf.setDataRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("data_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getDataRegionRatisSnapshotTriggerThreshold())).trim()));
        this.conf.setConfigNodeRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("config_node_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getConfigNodeRatisSnapshotTriggerThreshold())).trim()));
        this.conf.setSchemaRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("schema_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getSchemaRegionRatisSnapshotTriggerThreshold())).trim()));
        this.conf.setDataRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("data_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isDataRegionRatisLogUnsafeFlushEnable())).trim()));
        this.conf.setDataRegionRatisLogForceSyncNum(Integer.parseInt(properties.getProperty("data_region_ratis_log_force_sync_num", String.valueOf(this.conf.getDataRegionRatisLogForceSyncNum())).trim()));
        this.conf.setConfigNodeRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("config_node_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isConfigNodeRatisLogUnsafeFlushEnable())).trim()));
        this.conf.setSchemaRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("schema_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isSchemaRegionRatisLogUnsafeFlushEnable())).trim()));
        this.conf.setDataRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("data_region_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getDataRegionRatisLogSegmentSizeMax())).trim()));
        this.conf.setConfigNodeRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("config_node_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getConfigNodeRatisLogSegmentSizeMax())).trim()));
        this.conf.setSchemaRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("schema_region_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getSchemaRegionRatisLogSegmentSizeMax())).trim()));
        this.conf.setConfigNodeSimpleConsensusLogSegmentSizeMax(Long.parseLong(properties.getProperty("config_node_simple_consensus_log_segment_size_max_in_byte", String.valueOf(this.conf.getConfigNodeSimpleConsensusLogSegmentSizeMax())).trim()));
        this.conf.setDataRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("data_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getDataRegionRatisGrpcFlowControlWindow())).trim()));
        this.conf.setConfigNodeRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("config_node_ratis_grpc_flow_control_window", String.valueOf(this.conf.getConfigNodeRatisGrpcFlowControlWindow())).trim()));
        this.conf.setSchemaRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("schema_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getSchemaRegionRatisGrpcFlowControlWindow())).trim()));
        this.conf.setDataRegionRatisGrpcLeaderOutstandingAppendsMax(Integer.parseInt(properties.getProperty("data_region_ratis_grpc_leader_outstanding_appends_max", String.valueOf(this.conf.getDataRegionRatisGrpcLeaderOutstandingAppendsMax())).trim()));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMinMs())).trim()));
        this.conf.setConfigNodeRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("config_node_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getConfigNodeRatisRpcLeaderElectionTimeoutMinMs())).trim()));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs())).trim()));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMaxMs())).trim()));
        this.conf.setConfigNodeRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("config_node_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getConfigNodeRatisRpcLeaderElectionTimeoutMaxMs())).trim()));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs())).trim()));
        this.conf.setConfigNodeRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("config_node_ratis_request_timeout_ms", String.valueOf(this.conf.getConfigNodeRatisRequestTimeoutMs())).trim()));
        this.conf.setSchemaRegionRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("schema_region_ratis_request_timeout_ms", String.valueOf(this.conf.getSchemaRegionRatisRequestTimeoutMs())).trim()));
        this.conf.setDataRegionRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("data_region_ratis_request_timeout_ms", String.valueOf(this.conf.getDataRegionRatisRequestTimeoutMs())).trim()));
        this.conf.setConfigNodeRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("config_node_ratis_max_retry_attempts", String.valueOf(this.conf.getConfigNodeRatisMaxRetryAttempts())).trim()));
        this.conf.setConfigNodeRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("config_node_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getConfigNodeRatisInitialSleepTimeMs())).trim()));
        this.conf.setConfigNodeRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("config_node_ratis_max_sleep_time_ms", String.valueOf(this.conf.getConfigNodeRatisMaxSleepTimeMs())).trim()));
        this.conf.setDataRegionRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("data_region_ratis_max_retry_attempts", String.valueOf(this.conf.getDataRegionRatisMaxRetryAttempts())).trim()));
        this.conf.setDataRegionRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("data_region_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getDataRegionRatisInitialSleepTimeMs())).trim()));
        this.conf.setDataRegionRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("data_region_ratis_max_sleep_time_ms", String.valueOf(this.conf.getDataRegionRatisMaxSleepTimeMs())).trim()));
        this.conf.setSchemaRegionRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("schema_region_ratis_max_retry_attempts", String.valueOf(this.conf.getSchemaRegionRatisMaxRetryAttempts())).trim()));
        this.conf.setSchemaRegionRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("schema_region_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getSchemaRegionRatisInitialSleepTimeMs())).trim()));
        this.conf.setSchemaRegionRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("schema_region_ratis_max_sleep_time_ms", String.valueOf(this.conf.getSchemaRegionRatisMaxSleepTimeMs())).trim()));
        this.conf.setConfigNodeRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("config_node_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getConfigNodeRatisPreserveLogsWhenPurge())).trim()));
        this.conf.setSchemaRegionRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("schema_region_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getSchemaRegionRatisPreserveLogsWhenPurge())).trim()));
        this.conf.setDataRegionRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("data_region_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getDataRegionRatisPreserveLogsWhenPurge())).trim()));
        this.conf.setRatisFirstElectionTimeoutMinMs(Long.parseLong(properties.getProperty("ratis_first_election_timeout_min_ms", String.valueOf(this.conf.getRatisFirstElectionTimeoutMinMs())).trim()));
        this.conf.setRatisFirstElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("ratis_first_election_timeout_max_ms", String.valueOf(this.conf.getRatisFirstElectionTimeoutMaxMs())).trim()));
        this.conf.setConfigNodeRatisLogMax(Long.parseLong(properties.getProperty("config_node_ratis_log_max_size", String.valueOf(this.conf.getConfigNodeRatisLogMax())).trim()));
        this.conf.setSchemaRegionRatisLogMax(Long.parseLong(properties.getProperty("schema_region_ratis_log_max_size", String.valueOf(this.conf.getSchemaRegionRatisLogMax())).trim()));
        this.conf.setDataRegionRatisLogMax(Long.parseLong(properties.getProperty("data_region_ratis_log_max_size", String.valueOf(this.conf.getDataRegionRatisLogMax())).trim()));
        this.conf.setEnablePrintingNewlyCreatedPartition(Boolean.parseBoolean(properties.getProperty("enable_printing_newly_created_partition", String.valueOf(this.conf.isEnablePrintingNewlyCreatedPartition())).trim()));
        this.conf.setForceWalPeriodForConfigNodeSimpleInMs(Long.parseLong(properties.getProperty("force_wal_period_for_confignode_simple_in_ms", String.valueOf(this.conf.getForceWalPeriodForConfigNodeSimpleInMs())).trim()));
    }

    private void loadCQConfig(Properties properties) {
        int cqSubmitThread = Integer.parseInt(properties.getProperty("continuous_query_submit_thread_count", String.valueOf(this.conf.getCqSubmitThread())).trim());
        if (cqSubmitThread <= 0) {
            LOGGER.warn("continuous_query_submit_thread should be greater than 0, but current value is {}, ignore that and use the default value {}", (Object)cqSubmitThread, (Object)this.conf.getCqSubmitThread());
            cqSubmitThread = this.conf.getCqSubmitThread();
        }
        this.conf.setCqSubmitThread(cqSubmitThread);
        long cqMinEveryIntervalInMs = Long.parseLong(properties.getProperty("continuous_query_min_every_interval_in_ms", String.valueOf(this.conf.getCqMinEveryIntervalInMs())).trim());
        if (cqMinEveryIntervalInMs <= 0L) {
            LOGGER.warn("continuous_query_min_every_interval_in_ms should be greater than 0, but current value is {}, ignore that and use the default value {}", (Object)cqMinEveryIntervalInMs, (Object)this.conf.getCqMinEveryIntervalInMs());
            cqMinEveryIntervalInMs = this.conf.getCqMinEveryIntervalInMs();
        }
        this.conf.setCqMinEveryIntervalInMs(cqMinEveryIntervalInMs);
    }

    public boolean isSeedConfigNode() {
        return (this.conf.getInternalAddress().equals(this.conf.getTargetConfigNode().getIp()) || NodeUrlUtils.isLocalAddress((String)this.conf.getInternalAddress()) && NodeUrlUtils.isLocalAddress((String)this.conf.getTargetConfigNode().getIp())) && this.conf.getInternalPort() == this.conf.getTargetConfigNode().getPort();
    }

    public static ConfigNodeDescriptor getInstance() {
        return ConfigNodeDescriptorHolder.INSTANCE;
    }

    private static class ConfigNodeDescriptorHolder {
        private static final ConfigNodeDescriptor INSTANCE = new ConfigNodeDescriptor();

        private ConfigNodeDescriptorHolder() {
        }
    }
}

