/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum PipeRuntimeExceptionType {
    NON_CRITICAL_EXCEPTION(1),
    CRITICAL_EXCEPTION(2),
    CONNECTOR_CRITICAL_EXCEPTION(3);

    private final short type;

    private PipeRuntimeExceptionType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((short)this.type, (ByteBuffer)byteBuffer);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.type, (OutputStream)stream);
    }

    public static PipeRuntimeException deserializeFrom(ByteBuffer byteBuffer) {
        short type = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        switch (type) {
            case 1: {
                return PipeRuntimeNonCriticalException.deserializeFrom(byteBuffer);
            }
            case 2: {
                return PipeRuntimeCriticalException.deserializeFrom(byteBuffer);
            }
            case 3: {
                return PipeRuntimeConnectorCriticalException.deserializeFrom(byteBuffer);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported PipeRuntimeException type %s.", type));
    }

    public static PipeRuntimeException deserializeFrom(InputStream stream) throws IOException {
        short type = ReadWriteIOUtils.readShort((InputStream)stream);
        switch (type) {
            case 1: {
                return PipeRuntimeNonCriticalException.deserializeFrom(stream);
            }
            case 2: {
                return PipeRuntimeCriticalException.deserializeFrom(stream);
            }
            case 3: {
                return PipeRuntimeConnectorCriticalException.deserializeFrom(stream);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported PipeRuntimeException type %s.", type));
    }
}

