/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;

public interface ProgressIndex {
    public void serialize(ByteBuffer var1);

    public void serialize(OutputStream var1) throws IOException;

    public boolean isAfter(ProgressIndex var1);

    public boolean equals(ProgressIndex var1);

    public boolean equals(Object var1);

    public ProgressIndex updateToMinimumIsAfterProgressIndex(ProgressIndex var1);

    public ProgressIndexType getType();

    public static ProgressIndex blendProgressIndex(ProgressIndex progressIndex1, ProgressIndex progressIndex2) {
        if (progressIndex1 == null && progressIndex2 == null) {
            return new MinimumProgressIndex();
        }
        if (progressIndex1 == null || progressIndex1 instanceof MinimumProgressIndex) {
            return progressIndex2 == null ? new MinimumProgressIndex() : progressIndex2;
        }
        if (progressIndex2 == null || progressIndex2 instanceof MinimumProgressIndex) {
            return progressIndex1;
        }
        return new HybridProgressIndex(progressIndex1.getType().getType(), progressIndex1).updateToMinimumIsAfterProgressIndex(progressIndex2);
    }
}

