/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileDeviceIterator
implements Iterator<Pair<String, Boolean>> {
    private final TsFileSequenceReader reader;
    private final Queue<Pair<String, long[]>> queue;
    private Pair<String, Boolean> currentDevice = null;
    private MetadataIndexNode measurementNode;
    private final List<long[]> leafDeviceNodeOffsetList;

    public TsFileDeviceIterator(TsFileSequenceReader reader, List<long[]> leafDeviceNodeOffsetList, Queue<Pair<String, long[]>> queue) {
        this.reader = reader;
        this.queue = queue;
        this.leafDeviceNodeOffsetList = leafDeviceNodeOffsetList;
    }

    public Pair<String, Boolean> current() {
        return this.currentDevice;
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.leafDeviceNodeOffsetList.size() == 0) {
            return false;
        }
        long[] nextDeviceLeafNodeOffset = this.leafDeviceNodeOffsetList.remove(0);
        try {
            this.reader.getDevicesAndEntriesOfOneLeafNode(nextDeviceLeafNodeOffset[0], nextDeviceLeafNodeOffset[1], this.queue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public Pair<String, Boolean> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<String, long[]> startEndPair = this.queue.remove();
        try {
            this.measurementNode = this.reader.readMetadataIndexNode(((long[])startEndPair.right)[0], ((long[])startEndPair.right)[1]);
            boolean isAligned = this.reader.isAlignedDevice(this.measurementNode);
            this.currentDevice = new Pair<String, Boolean>((String)startEndPair.left, isAligned);
            return this.currentDevice;
        }
        catch (IOException e) {
            throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
        }
    }

    public MetadataIndexNode getFirstMeasurementNodeOfCurrentDevice() {
        return this.measurementNode;
    }
}

