/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoResizingBuffer {
    private byte[] array;
    private int bufTooLargeCounter = 5;
    private final int initialCapacity;
    private long lastShrinkTime;
    private static final Logger logger = LoggerFactory.getLogger(AutoResizingBuffer.class);

    public AutoResizingBuffer(int initialCapacity) {
        this.array = new byte[initialCapacity];
        this.initialCapacity = initialCapacity;
    }

    public void resizeIfNecessary(int size) {
        int currentCapacity = this.array.length;
        double loadFactor = 0.6;
        if (currentCapacity < size) {
            int growCapacity = currentCapacity + (currentCapacity >> 1);
            int newCapacity = Math.max(growCapacity, size);
            this.array = Arrays.copyOf(this.array, newCapacity);
            this.bufTooLargeCounter = 5;
        } else if (size > this.initialCapacity && (double)currentCapacity * 0.6 > (double)size && this.bufTooLargeCounter-- <= 0 && System.currentTimeMillis() - this.lastShrinkTime > 60000L) {
            this.array = Arrays.copyOf(this.array, size + (currentCapacity - size) / 2);
            this.bufTooLargeCounter = 5;
            this.lastShrinkTime = System.currentTimeMillis();
        }
    }

    public byte[] array() {
        return this.array;
    }
}

