/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.utils;

import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.exception.MemTablePinException;
import org.apache.iotdb.db.wal.exception.WALPipeException;
import org.apache.iotdb.db.wal.node.WALNode;
import org.apache.iotdb.db.wal.utils.WALEntryPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALEntryHandler {
    private static final Logger logger = LoggerFactory.getLogger(WALEntryHandler.class);
    private long memTableId = -1L;
    private volatile WALEntryValue value;
    private final WALEntryPosition walEntryPosition = new WALEntryPosition();
    private WALNode walNode = null;

    public WALEntryHandler(WALEntryValue value) {
        this.value = value;
    }

    public void pinMemTable() throws MemTablePinException {
        if (this.walNode == null || this.memTableId < 0L) {
            throw new MemTablePinException("Fail to pin memTable because of internal error.");
        }
        this.walNode.pinMemTable(this.memTableId);
    }

    public void unpinMemTable() throws MemTablePinException {
        if (this.walNode == null || this.memTableId < 0L) {
            throw new MemTablePinException("Fail to pin memTable because of internal error.");
        }
        this.walNode.unpinMemTable(this.memTableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsertNode getValue() throws WALPipeException {
        WALEntryValue res = this.value;
        if (res != null) {
            if (res instanceof InsertNode) {
                return (InsertNode)((Object)this.value);
            }
            throw new WALPipeException("Fail to get value because the entry type isn't InsertNode.");
        }
        while (!this.walEntryPosition.canRead()) {
            try {
                WALEntryHandler wALEntryHandler = this;
                synchronized (wALEntryHandler) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted when waiting for result.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        InsertNode node = null;
        try {
            node = this.walEntryPosition.readInsertNodeViaCache();
        }
        catch (Exception e) {
            throw new WALPipeException("Fail to get value because the file content isn't correct.", e);
        }
        if (node == null) {
            throw new WALPipeException(String.format("Fail to get the wal value of the position %s.", this.walEntryPosition));
        }
        return node;
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    public void setMemTableId(long memTableId) {
        this.memTableId = memTableId;
    }

    public void setWalNode(WALNode walNode) {
        this.walNode = walNode;
        this.walEntryPosition.setWalNode(walNode);
    }

    public WALEntryPosition getWalEntryPosition() {
        return this.walEntryPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntryPosition(long walFileVersionId, long position) {
        this.walEntryPosition.setEntryPosition(walFileVersionId, position);
        this.value = null;
        WALEntryHandler wALEntryHandler = this;
        synchronized (wALEntryHandler) {
            this.notifyAll();
        }
    }

    public int getSize() {
        return this.walEntryPosition.getSize();
    }

    public void setSize(int size) {
        this.walEntryPosition.setSize(size);
    }

    public String toString() {
        return "WALEntryHandler{memTableId=" + this.memTableId + ", value=" + this.value + ", walEntryPosition=" + this.walEntryPosition + '}';
    }
}

