/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.tools.SortReader;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;

public class MemoryReader
implements SortReader {
    private final List<MergeSortKey> cachedData;
    private final int size;
    private int rowIndex;

    public MemoryReader(List<MergeSortKey> cachedTsBlock) {
        this.cachedData = cachedTsBlock;
        this.size = cachedTsBlock.size();
        this.rowIndex = 0;
    }

    @Override
    public MergeSortKey next() {
        MergeSortKey sortKey = this.cachedData.get(this.rowIndex);
        ++this.rowIndex;
        return sortKey;
    }

    @Override
    public boolean hasNext() throws IoTDBException {
        return this.cachedData != null && this.rowIndex != this.size;
    }

    @Override
    public void close() throws IoTDBException {
    }
}

