/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.handler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.service.thrift.handler.BaseServerContextHandler;
import org.apache.iotdb.db.service.thrift.handler.RPCServiceThriftHandlerMetrics;
import org.apache.iotdb.db.service.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TTransport;

public class RPCServiceThriftHandler
extends BaseServerContextHandler
implements TServerEventHandler {
    private final AtomicLong thriftConnectionNumber = new AtomicLong(0L);
    private final IClientRPCServiceWithHandler eventHandler;

    public RPCServiceThriftHandler(IClientRPCServiceWithHandler eventHandler) {
        this.eventHandler = eventHandler;
        MetricService.getInstance().addMetricSet((IMetricSet)new RPCServiceThriftHandlerMetrics(this.thriftConnectionNumber));
    }

    @Override
    public ServerContext createContext(TProtocol in, TProtocol out) {
        this.thriftConnectionNumber.incrementAndGet();
        return super.createContext(in, out);
    }

    @Override
    public void deleteContext(ServerContext arg0, TProtocol in, TProtocol out) {
        this.eventHandler.handleClientExit();
        this.thriftConnectionNumber.decrementAndGet();
        super.deleteContext(arg0, in, out);
    }

    public void preServe() {
    }

    public void processContext(ServerContext arg0, TTransport arg1, TTransport arg2) {
    }
}

