/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CompactionMetrics
implements IMetricSet {
    private static final String NOT_ALIGNED = "not_aligned";
    private static final String ALIGNED = "aligned";
    private static final String METADATA = "metadata";
    private static final List<String> TYPES = Arrays.asList("aligned", "not_aligned");
    private static final CompactionMetrics INSTANCE = new CompactionMetrics();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10000L;
    private final AtomicInteger waitingSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishCrossCompactionTaskNum = new AtomicInteger(0);
    private final Map<String, Counter[]> writeCounters = new ConcurrentHashMap<String, Counter[]>();
    private final Map<String, Counter[]> readCounters = new ConcurrentHashMap<String, Counter[]>();
    private Counter totalCompactionWriteInfoCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactionReadInfoCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedPointCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDirectlyFlushChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDeserializedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalMergedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Timer seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private CompactionMetrics() {
        for (String type : TYPES) {
            this.readCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
            this.writeCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
        }
    }

    private void bindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.writeCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
        this.totalCompactionWriteInfoCounter = metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    private void unbindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
        metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    public void recordWriteInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.writeCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
        this.totalCompactionWriteInfoCounter.inc(byteNum);
    }

    private void bindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.readCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
        this.totalCompactionReadInfoCounter = metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
        metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void recordReadInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.readCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
        this.totalCompactionReadInfoCounter.inc(byteNum);
    }

    private void bindPerformanceInfo(AbstractMetricService metricService) {
        this.totalCompactedPointCounter = metricService.getOrCreateCounter("compacted_point_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalCompactedChunkCounter = metricService.getOrCreateCounter("compacted_chunk_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDirectlyFlushChunkCounter = metricService.getOrCreateCounter("directly_flush_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDeserializedChunkCounter = metricService.getOrCreateCounter("deserialized_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalMergedChunkCounter = metricService.getOrCreateCounter("merged_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindPerformanceInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.COUNTER, "compacted_point_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "compacted_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "directly_flush_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "deserialized_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "merged_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void recordSummaryInfo(CompactionTaskSummary summary) {
        this.totalCompactedPointCounter.inc(summary.getProcessPointNum());
        this.totalCompactedChunkCounter.inc((long)summary.getProcessChunkNum());
        this.totalDirectlyFlushChunkCounter.inc((long)summary.getDirectlyFlushChunkNum());
        this.totalDeserializedChunkCounter.inc((long)summary.getDeserializeChunkCount());
        this.totalMergedChunkCounter.inc((long)summary.getMergedChunkNum());
    }

    public void recordTaskFinishOrAbort(boolean isCrossTask, boolean isSeq, long timeCost) {
        if (isCrossTask) {
            this.finishCrossCompactionTaskNum.incrementAndGet();
            this.crossCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
        } else if (isSeq) {
            this.finishSeqInnerCompactionTaskNum.incrementAndGet();
            this.seqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
        } else {
            this.finishUnseqInnerCompactionTaskNum.incrementAndGet();
            this.unSeqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
        }
    }

    private void bindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        this.unSeqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        this.crossCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "cross_compaction"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "cross"});
    }

    private void unbindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "cross_compaction"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "cross"});
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindTaskInfo(metricService);
        this.bindWriteInfo(metricService);
        this.bindReadInfo(metricService);
        this.bindPerformanceInfo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTaskInfo(metricService);
        this.unbindWriteInfo(metricService);
        this.unbindReadInfo(metricService);
        this.unbindPerformanceInfo(metricService);
    }

    private void updateCompactionTaskInfo() {
        if (System.currentTimeMillis() - this.lastUpdateTime < 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        Map<CompactionTaskType, Map<CompactionTaskStatus, Integer>> compactionTaskStatisticMap = CompactionTaskManager.getInstance().getCompactionTaskStatistic();
        this.waitingSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.runningSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
    }

    public static CompactionMetrics getInstance() {
        return INSTANCE;
    }
}

