/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.impl;

import com.google.common.base.Joiner;
import java.time.ZoneId;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.v2.GrafanaApiService;
import org.apache.iotdb.db.protocol.rest.v2.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.v2.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.SQL;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class GrafanaApiServiceImpl
extends GrafanaApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler();
    private final long timePrecision;

    public GrafanaApiServiceImpl() {
        switch (CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                this.timePrecision = 1000000L;
                break;
            }
            case "us": {
                this.timePrecision = 1000L;
                break;
            }
            default: {
                this.timePrecision = 1L;
            }
        }
    }

    public Response variables(SQL sql, SecurityContext securityContext) {
        RequestValidationHandler.validateSQL(sql);
        Statement statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
        if (!(statement instanceof ShowStatement) && !(statement instanceof QueryStatement)) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
        if (response != null) {
            return response;
        }
        long queryId = SESSION_MANAGER.requestQueryId();
        ExecutionResult result = COORDINATOR.execute(statement, queryId, null, sql.getSql(), this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        try {
            Response response2 = QueryDataSetHandler.fillGrafanaVariablesResult(queryExecution, statement);
            threadName.close();
            return response2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response expression(ExpressionRequest expressionRequest, SecurityContext securityContext) {
        try {
            Statement statement;
            Response response;
            RequestValidationHandler.validateExpressionRequest(expressionRequest);
            String expression = Joiner.on((String)",").join((Iterable)expressionRequest.getExpression());
            String prefixPaths = Joiner.on((String)",").join((Iterable)expressionRequest.getPrefixPath());
            long startTime = (long)(expressionRequest.getStartTime().doubleValue() * (double)this.timePrecision);
            long endTime = (long)(expressionRequest.getEndTime().doubleValue() * (double)this.timePrecision);
            String sql = "select " + expression + " from " + prefixPaths + " where timestamp>=" + startTime + " and timestamp<= " + endTime;
            if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getCondition())) {
                sql = sql + " and " + expressionRequest.getCondition();
            }
            if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getControl())) {
                sql = sql + " " + expressionRequest.getControl();
            }
            if ((response = this.authorizationHandler.checkAuthority(securityContext, statement = StatementGenerator.createStatement(sql, ZoneId.systemDefault()))) != null) {
                return response;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, null, sql, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            try (SetThreadName threadName = new SetThreadName(result.queryId.getId());){
                if (((QueryStatement)statement).isGroupByLevel()) {
                    Response response2 = QueryDataSetHandler.fillAggregationPlanDataSet(queryExecution, 0);
                    return response2;
                }
                Response response2 = QueryDataSetHandler.fillDataSetWithTimestamps(queryExecution, 0, this.timePrecision);
                return response2;
            }
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }

    public Response login(SecurityContext securityContext) {
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response node(List<String> requestBody, SecurityContext securityContext) {
        if (requestBody == null || requestBody.isEmpty()) return QueryDataSetHandler.fillGrafanaNodesResult(null);
        PartialPath path = new PartialPath(Joiner.on((String)".").join(requestBody));
        String sql = "show child paths " + path;
        Statement statement = StatementGenerator.createStatement(sql, ZoneId.systemDefault());
        Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
        if (response != null) {
            return response;
        }
        long queryId = SESSION_MANAGER.requestQueryId();
        ExecutionResult result = COORDINATOR.execute(statement, queryId, null, sql, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        try {
            Response response2 = QueryDataSetHandler.fillGrafanaNodesResult(queryExecution);
            threadName.close();
            return response2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    threadName.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
        }
    }
}

