/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.protocol.influxdb.meta.IInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.meta.TagInfoRecords;

public abstract class AbstractInfluxDBMetaManager
implements IInfluxDBMetaManager {
    protected static final String SELECT_TAG_INFO_SQL = "select database_name,measurement_name,tag_name,tag_order from root.TAG_INFO ";
    protected static Map<String, Map<String, Map<String, Integer>>> database2Measurement2TagOrders = new HashMap<String, Map<String, Map<String, Integer>>>();

    @Override
    public Map<String, Integer> getTagOrders(String database, String measurement, long sessionID) {
        Map<String, Integer> tagOrders = new HashMap<String, Integer>();
        Map<String, Map<String, Integer>> measurement2TagOrders = database2Measurement2TagOrders.get(database);
        if (measurement2TagOrders != null) {
            tagOrders = measurement2TagOrders.get(measurement);
        }
        if (tagOrders == null) {
            tagOrders = new HashMap();
        }
        return tagOrders;
    }

    abstract void setStorageGroup(String var1, long var2);

    abstract void updateTagInfoRecords(TagInfoRecords var1, long var2);

    public final synchronized Map<String, Map<String, Integer>> createDatabase(String database, long sessionID) {
        Map<String, Map<String, Integer>> measurement2TagOrders = database2Measurement2TagOrders.get(database);
        if (measurement2TagOrders != null) {
            return measurement2TagOrders;
        }
        this.setStorageGroup(database, sessionID);
        measurement2TagOrders = new HashMap<String, Map<String, Integer>>();
        database2Measurement2TagOrders.put(database, measurement2TagOrders);
        return measurement2TagOrders;
    }

    public final synchronized Map<String, Integer> getTagOrdersWithAutoCreatingSchema(String database, String measurement, long sessionID) {
        return this.createDatabase(database, sessionID).computeIfAbsent(measurement, m -> new HashMap());
    }

    @Override
    public final synchronized String generatePath(String database, String measurement, Map<String, String> tags, Set<String> fields, long sessionID) {
        Map<String, Integer> tagKeyToLayerOrders = this.getTagOrdersWithAutoCreatingSchema(database, measurement, sessionID);
        HashMap<String, Integer> newTagKeyToLayerOrders = new HashMap<String, Integer>(tagKeyToLayerOrders);
        HashMap<Integer, String> layerOrderToTagKeysInPath = new HashMap<Integer, String>();
        int tagNumber = tagKeyToLayerOrders.size();
        TagInfoRecords newTagInfoRecords = null;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            String tagKey = tag.getKey();
            if (!newTagKeyToLayerOrders.containsKey(tagKey)) {
                if (newTagInfoRecords == null) {
                    newTagInfoRecords = new TagInfoRecords();
                }
                newTagInfoRecords.add(database, measurement, tagKey, ++tagNumber);
                newTagKeyToLayerOrders.put(tagKey, tagNumber);
            }
            layerOrderToTagKeysInPath.put((Integer)newTagKeyToLayerOrders.get(tagKey), tagKey);
        }
        if (newTagInfoRecords != null) {
            this.updateTagInfoRecords(newTagInfoRecords, sessionID);
            database2Measurement2TagOrders.get(database).put(measurement, newTagKeyToLayerOrders);
        }
        StringBuilder path = new StringBuilder("root.").append(database).append(".").append(measurement);
        for (int i = 1; i <= tagNumber; ++i) {
            path.append(".").append(layerOrderToTagKeysInPath.containsKey(i) ? tags.get(layerOrderToTagKeysInPath.get(i)) : "PH");
        }
        return path.toString();
    }
}

