/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.wal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResource;
import org.apache.iotdb.db.wal.utils.WALEntryHandler;

public class PipeWALResourceManager {
    private final Map<Long, PipeWALResource> memtableIdToPipeWALResourceMap = new ConcurrentHashMap<Long, PipeWALResource>();
    private static final int SEGMENT_LOCK_COUNT = 32;
    private final ReentrantLock[] memtableIdSegmentLocks = new ReentrantLock[32];
    private static final ScheduledExecutorService PIPE_WAL_RESOURCE_TTL_CHECKER = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_WAL_RESOURCE_TTL_CHECKER.getName());

    public PipeWALResourceManager() {
        for (int i = 0; i < 32; ++i) {
            this.memtableIdSegmentLocks[i] = new ReentrantLock();
        }
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)PIPE_WAL_RESOURCE_TTL_CHECKER, () -> {
            Iterator<Map.Entry<Long, PipeWALResource>> iterator = this.memtableIdToPipeWALResourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, PipeWALResource> entry = iterator.next();
                ReentrantLock lock = this.memtableIdSegmentLocks[(int)(entry.getKey() % 32L)];
                lock.lock();
                try {
                    if (!entry.getValue().invalidateIfPossible()) continue;
                    iterator.remove();
                }
                finally {
                    lock.unlock();
                }
            }
        }, (long)60000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(long memtableId, WALEntryHandler walEntryHandler) {
        ReentrantLock lock = this.memtableIdSegmentLocks[(int)(memtableId % 32L)];
        lock.lock();
        try {
            this.memtableIdToPipeWALResourceMap.computeIfAbsent(memtableId, id -> new PipeWALResource(walEntryHandler)).pin();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpin(long memtableId) {
        ReentrantLock lock = this.memtableIdSegmentLocks[(int)(memtableId % 32L)];
        lock.lock();
        try {
            this.memtableIdToPipeWALResourceMap.get(memtableId).unpin();
        }
        finally {
            lock.unlock();
        }
    }
}

