/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionHybridExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionHybridExtractor.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue();

    @Override
    public void extract(PipeRealtimeEvent event) {
        Event eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return true;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return true;
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        if (this.isApproachingCapacity()) {
            event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
            return;
        }
        if (!event.getTsFileEpoch().getState(this).equals((Object)TsFileEpoch.State.USING_TSFILE) && !this.pendingQueue.offer(event)) {
            LOGGER.warn("extractTabletInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor {} has reached capacity, discard tablet event {}, current state {}", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> state.equals((Object)TsFileEpoch.State.EMPTY) ? TsFileEpoch.State.USING_TSFILE : state);
        if (!this.pendingQueue.offer(event)) {
            LOGGER.warn("extractTsFileInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor {} has reached capacity, discard TsFile event {}, current state {}", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
        }
    }

    private boolean isApproachingCapacity() {
        return this.pendingQueue.size() >= PipeConfig.getInstance().getPipeExtractorPendingQueueTabletLimit();
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent;
            Event eventToSupply = realtimeEvent.getEvent();
            if (eventToSupply instanceof TabletInsertionEvent) {
                suppliedEvent = this.supplyTabletInsertion(realtimeEvent);
            } else if (eventToSupply instanceof TsFileInsertionEvent) {
                suppliedEvent = this.supplyTsFileInsertion(realtimeEvent);
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s to supply.", eventToSupply.getClass(), this));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName());
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    private Event supplyTabletInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> state.equals((Object)TsFileEpoch.State.EMPTY) ? TsFileEpoch.State.USING_TABLET : state);
        if (event.getTsFileEpoch().getState(this).equals((Object)TsFileEpoch.State.USING_TABLET)) {
            if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
                return event.getEvent();
            }
            event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
            LOGGER.warn("Increase reference count for event {} error.", (Object)event);
            return null;
        }
        return null;
    }

    private Event supplyTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            if (state.equals((Object)TsFileEpoch.State.EMPTY)) {
                LOGGER.warn(String.format("EMPTY TsFileEpoch when supplying TsFile Event %s", event));
                return TsFileEpoch.State.USING_TSFILE;
            }
            return state;
        });
        if (event.getTsFileEpoch().getState(this).equals((Object)TsFileEpoch.State.USING_TSFILE)) {
            if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
                return event.getEvent();
            }
            String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
            LOGGER.warn(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            return null;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.pendingQueue.clear();
    }
}

