/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends EnrichedEvent
implements TsFileInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    private final long startTime;
    private final long endTime;
    private final TsFileResource resource;
    private File tsFile;
    private final AtomicBoolean isClosed;
    private TsFileInsertionDataContainer dataContainer;

    public PipeTsFileInsertionEvent(TsFileResource resource) {
        this(resource, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(TsFileResource resource, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        super(pipeTaskMeta, pattern);
        TsFileProcessor processor;
        this.startTime = startTime;
        this.endTime = endTime;
        this.resource = resource;
        this.tsFile = resource.getTsFile();
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTsFileClose() throws InterruptedException {
        if (!this.isClosed.get()) {
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait();
                }
            }
        }
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public boolean hasTimeFilter() {
        return this.startTime != Long.MIN_VALUE || this.endTime != Long.MAX_VALUE;
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.tsFile = PipeResourceManager.file().increaseFileReference(this.tsFile, true);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.file().decreaseFileReference(this.tsFile);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProgressIndex getProgressIndex() {
        try {
            this.waitForTsFileClose();
            return this.resource.getMaxProgressIndexAfterClose();
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()));
            Thread.currentThread().interrupt();
            return new MinimumProgressIndex();
        }
    }

    @Override
    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta pipeTaskMeta, String pattern) {
        return new PipeTsFileInsertionEvent(this.resource, pipeTaskMeta, pattern, this.startTime, this.endTime);
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        try {
            if (this.dataContainer == null) {
                this.waitForTsFileClose();
                this.dataContainer = new TsFileInsertionDataContainer(this.tsFile, this.getPattern(), this.startTime, this.endTime);
            }
            return this.dataContainer.toTabletInsertionEvents();
        }
        catch (InterruptedException e) {
            String errorMsg = String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            Thread.currentThread().interrupt();
            throw new PipeException(errorMsg);
        }
        catch (IOException e) {
            String errorMsg = String.format("Read TsFile %s error.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    public String toString() {
        return "PipeTsFileInsertionEvent{resource=" + this.resource + ", tsFile=" + this.tsFile + ", isClosed=" + this.isClosed + '}';
    }
}

