/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.scalar;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class RoundFunctionTransformer
extends UnaryTransformer {
    private final TSDataType targetDataType;
    protected int places;

    public RoundFunctionTransformer(LayerPointReader layerPointReader, TSDataType targetDataType, int places) {
        super(layerPointReader);
        this.targetDataType = targetDataType;
        this.places = places;
    }

    @Override
    public TSDataType getDataType() {
        return this.targetDataType;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        switch (this.layerPointReaderDataType) {
            case INT32: {
                this.cachedDouble = Math.rint((double)this.layerPointReader.currentInt() * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places);
                return;
            }
            case INT64: {
                this.cachedDouble = Math.rint((double)this.layerPointReader.currentLong() * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places);
                return;
            }
            case FLOAT: {
                this.cachedDouble = Math.rint((double)this.layerPointReader.currentFloat() * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places);
                return;
            }
            case DOUBLE: {
                this.cachedDouble = Math.rint(this.layerPointReader.currentDouble() * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places);
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.layerPointReaderDataType));
    }
}

